/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.Config;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.LicenseMemoryChecker;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHome;
import com.hazelcast.internal.util.phonehome.PhoneHomeParameterCreator;
import com.hazelcast.license.domain.License;
import com.hazelcast.memory.MemoryUnit;
import java.util.BitSet;

public class EnterprisePhoneHome
extends PhoneHome {
    public EnterprisePhoneHome(Node hazelcastNode) {
        super(hazelcastNode);
    }

    @Override
    public PhoneHomeParameterCreator createParameters() {
        MetricsCollector restsMetricCollector;
        Config config = this.hazelcastNode.getConfig();
        boolean restServiceEnabled = config.getRestConfig().isEnabled();
        if (restServiceEnabled && (restsMetricCollector = (MetricsCollector)this.hazelcastNode.getNodeEngine().getServiceOrNull("hz:impl:restServiceImpl")) != null) {
            this.registerMetricsCollector(restsMetricCollector);
        }
        PhoneHomeParameterCreator parameters = super.createParameters();
        ClusterServiceImpl clusterService = this.hazelcastNode.getClusterService();
        NativeMemoryConfig memoryConfig = config.getNativeMemoryConfig();
        long totalNativeMemorySize = (long)clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR) * memoryConfig.getCapacity().bytes();
        String nativeMemoryParameter = Long.toString(MemoryUnit.BYTES.toGigaBytes(totalNativeMemorySize));
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.hazelcastNode.getNodeExtension();
        License license = nodeExtension.getLicense();
        String keyHash = license.getKey() != null ? license.computeKeyHash() : "";
        boolean isLicenseOEM = license.isOem();
        LicenseMemoryChecker checker = nodeExtension.getLicenseMemoryChecker();
        BitSet hdFlags = checker.getHdMemoryLimitFlags();
        boolean tieredStorageEnabled = config.getMapConfigs().values().stream().anyMatch(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled());
        parameters.addParam("e", "true");
        parameters.addParam("l", keyHash);
        parameters.addParam("oem", Boolean.toString(isLicenseOEM));
        parameters.addParam("hdgb", nativeMemoryParameter);
        parameters.addParam("lkv", license.getVersion().name());
        for (int i = 2; i >= 0; --i) {
            if (!hdFlags.get(i)) continue;
            parameters.addParam("hdp", String.valueOf(LicenseMemoryChecker.memoryBitFlagToLimit(i)));
            break;
        }
        parameters.addParam("tsl", String.valueOf(license.getAllowedTieredStoreSize()));
        if (tieredStorageEnabled) {
            TieredStoreServiceImpl tieredStoreService = (TieredStoreServiceImpl)this.hazelcastNode.getNodeEngine().getService("hz:ee:tieredStoreServiceImpl");
            long hlogLength = tieredStoreService.getMetrics().getPerMemberMetrics().getLastSeenHybridLogLength();
            parameters.addParam("tsh", String.valueOf(hlogLength));
            if (this.hazelcastNode.isMaster()) {
                parameters.addParam("tsmax", String.valueOf(checker.getMaxTSMemoryConsumption()));
                BitSet tsFlags = checker.getTsMemoryLimitFlags();
                for (int i = 2; i >= 0; --i) {
                    if (!tsFlags.get(i)) continue;
                    parameters.addParam("tsp", String.valueOf(LicenseMemoryChecker.memoryBitFlagToLimit(i)));
                    break;
                }
            }
        }
        return parameters;
    }
}

