/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.gcp.GcpDiscoveryStrategy;
import com.hazelcast.gcp.GcpProperties;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.spi.utils.RestClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class GcpDiscoveryStrategyFactory
implements DiscoveryStrategyFactory {
    private static final ILogger LOGGER = Logger.getLogger(GcpDiscoveryStrategyFactory.class);

    @Override
    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
        return GcpDiscoveryStrategy.class;
    }

    @Override
    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        return new GcpDiscoveryStrategy(properties);
    }

    @Override
    public Collection<PropertyDefinition> getConfigurationProperties() {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        for (GcpProperties property : GcpProperties.values()) {
            result.add(property.getDefinition());
        }
        return result;
    }

    @Override
    public boolean isAutoDetectionApplicable() {
        return GcpDiscoveryStrategyFactory.googleInternalDnsConfigured() && GcpDiscoveryStrategyFactory.metadataFlavorGoogle() && GcpDiscoveryStrategyFactory.serviceAccountAttached();
    }

    private static boolean googleInternalDnsConfigured() {
        return GcpDiscoveryStrategyFactory.readFileContents("/etc/resolv.conf").contains("google.internal") || GcpDiscoveryStrategyFactory.readFileContents("/etc/hosts").contains("google.internal");
    }

    static String readFileContents(String fileName) {
        String string;
        FileInputStream is = null;
        try {
            File file = new File(fileName);
            byte[] data = new byte[(int)file.length()];
            is = new FileInputStream(file);
            ((InputStream)is).read(data);
            string = new String(data, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not get " + fileName, e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(is);
                throw throwable;
            }
        }
        IOUtil.closeResource(is);
        return string;
    }

    private static boolean metadataFlavorGoogle() {
        return GcpDiscoveryStrategyFactory.isEndpointAvailable("http://metadata.google.internal");
    }

    private static boolean serviceAccountAttached() {
        try {
            return GcpDiscoveryStrategyFactory.isEndpointAvailable("http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/");
        }
        catch (Exception e) {
            LOGGER.warning("Hazelcast running on GCP instance, but no service account attached. Cannot use Hazelcast GCP discovery.");
            LOGGER.finest(e);
            return false;
        }
    }

    static boolean isEndpointAvailable(String url) {
        return !RestClient.create(url, 1).withRequestTimeoutSeconds(1).withRetries(1).withHeader("Metadata-Flavor", "Google").get().getBody().isEmpty();
    }

    @Override
    public DiscoveryStrategyFactory.DiscoveryStrategyLevel discoveryStrategyLevel() {
        return DiscoveryStrategyFactory.DiscoveryStrategyLevel.CLOUD_VM;
    }
}

