/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.sync;

import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncStateManager;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;

public class WanSyncStateStartOperation
extends Operation
implements IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private UUID syncUUID;
    private String wanReplicationName;
    private String wanPublisherId;
    private long creationTime;
    private Collection<UUID> memberUUIDs;

    public WanSyncStateStartOperation() {
    }

    public WanSyncStateStartOperation(UUID syncUUID, String wanReplicationName, String wanPublisherId, long creationTime, Collection<UUID> memberUUIDs) {
        this.syncUUID = syncUUID;
        this.wanReplicationName = wanReplicationName;
        this.wanPublisherId = wanPublisherId;
        this.creationTime = creationTime;
        this.memberUUIDs = memberUUIDs;
    }

    @Override
    public void run() throws Exception {
        EnterpriseWanReplicationService wanReplicationService = (EnterpriseWanReplicationService)this.getService();
        WanSyncStateManager wanSyncStateManager = wanReplicationService.getSyncManager().getWanSyncStateManager();
        wanSyncStateManager.start(this.syncUUID, this.wanReplicationName, this.wanPublisherId, this.creationTime, this.memberUUIDs);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.syncUUID);
        out.writeString(this.wanReplicationName);
        out.writeString(this.wanPublisherId);
        out.writeLong(this.creationTime);
        SerializationUtil.writeCollection(this.memberUUIDs, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.syncUUID = UUIDSerializationUtil.readUUID(in);
        this.wanReplicationName = in.readString();
        this.wanPublisherId = in.readString();
        this.creationTime = in.readLong();
        this.memberUUIDs = SerializationUtil.readCollection(in);
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    public String getServiceName() {
        return "hz:core:wanReplicationService";
    }
}

