/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.sync;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncStateGetOperation;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.impl.WanSyncStateResult;
import com.hazelcast.wan.impl.WanSyncStats;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class WanSyncStateManager {
    private static final int MAX_STATE_COUNT = 100;
    private static final int MAX_STATE_LIFESPAN_MILLIS = (int)TimeUnit.DAYS.toMillis(7L);
    private static final int TERMINAL_STAGE_ORDER = 2;
    private static final int HUNDRED = 100;
    private static final String COMMON_ERROR_MESSAGE = "Returned results may be behind the actual progress but not forward.";
    private final Map<UUID, WanSyncStatePerCluster> store = new ConcurrentHashMap<UUID, WanSyncStatePerCluster>();
    private final EnterpriseWanReplicationService wanReplicationService;
    private final Node node;
    private final ILogger logger;

    WanSyncStateManager(EnterpriseWanReplicationService wanReplicationService, Node node) {
        this.wanReplicationService = wanReplicationService;
        this.node = node;
        this.logger = node.getLogger(this.getClass());
    }

    void start(UUID syncUUID, String wanReplicationName, String publisherId, long creationTime, Collection<UUID> memberUUIDs) {
        this.collectGarbage();
        this.store.put(syncUUID, new WanSyncStatePerCluster(wanReplicationName, publisherId, creationTime, memberUUIDs));
    }

    public void initializeLocal(UUID syncUUID, Collection<String> mapNames, NodeEngine nodeEngine) {
        WanSyncStatePerMember localMemberState = this.getLocalMemberState(syncUUID);
        if (localMemberState != null) {
            localMemberState.initializeWeight(mapNames, nodeEngine);
        }
    }

    public <T extends WanSyncStats> void progressLocal(UUID syncUUID, Map<String, T> syncStatsMap) {
        WanSyncStatePerMember localMemberState = this.getLocalMemberState(syncUUID);
        if (localMemberState != null) {
            localMemberState.progressFromStats(syncStatsMap);
        }
    }

    public void finishLocal(UUID syncUUID, WanSyncStateStage stage) {
        WanSyncStatePerMember localMemberState = this.getLocalMemberState(syncUUID);
        if (localMemberState != null) {
            localMemberState.advanceStage(stage);
        }
    }

    WanSyncStatePerMember getLocalMemberState(UUID syncUUID) {
        UUID localMemberUUID = this.node.getLocalMember().getUuid();
        WanSyncStatePerCluster state = this.store.get(syncUUID);
        if (state == null) {
            return null;
        }
        return state.perMemberStates.get(localMemberUUID);
    }

    public EnterpriseWanSyncStateResult query(UUID syncUUID) {
        if (!this.node.getClusterService().getClusterVersion().isGreaterOrEqual(Versions.V5_3)) {
            throw new UnsupportedOperationException("Wan sync state requires cluster version >= 5.3");
        }
        WanSyncStatePerCluster state = this.store.get(syncUUID);
        if (state == null) {
            return null;
        }
        LinkedList<String> messages = new LinkedList<String>();
        Map futures = this.invokeOnMembers(() -> new WanSyncStateGetOperation(syncUUID), state, messages);
        for (UUID memberUUID : futures.keySet()) {
            CompletableFuture future = futures.get(memberUUID);
            try {
                state.perMemberStates.get(memberUUID).progressFromState((WanSyncStatePerMember)future.join());
            }
            catch (Exception e) {
                String message = "Could not join invocation on Member: " + String.valueOf(memberUUID) + ". Reason: " + e.getMessage() + ". Returned results may be behind the actual progress but not forward.";
                this.logger.warning(message, e);
                messages.add(message);
            }
        }
        return new EnterpriseWanSyncStateResult(state, messages);
    }

    private <E> Map<UUID, CompletableFuture<E>> invokeOnMembers(Supplier<Operation> supplier, WanSyncStatePerCluster state, List<String> messages) {
        HashMap futures = new HashMap(state.perMemberStates.size());
        state.perMemberStates.entrySet().stream().filter(entry -> !((WanSyncStatePerMember)entry.getValue()).isFinishedOrFailed()).map(Map.Entry::getKey).filter(uuid -> !uuid.equals(this.node.getLocalMember().getUuid())).map(memberUUID -> {
            MemberImpl member = this.node.getClusterService().getMember((UUID)memberUUID);
            if (member == null) {
                String message = "Member: " + String.valueOf(memberUUID) + " is no longer part of the cluster. Returned results may be behind the actual progress but not forward.";
                this.logger.info(message);
                messages.add(message);
            }
            return member;
        }).filter(Objects::nonNull).forEach(member -> {
            try {
                futures.put(member.getUuid(), this.node.getNodeEngine().getOperationService().invokeOnTargetAsync("hz:core:wanReplicationService", (Operation)supplier.get(), member.getAddress()));
            }
            catch (Exception e) {
                String message = "Could not invoke operation on Member: " + String.valueOf(member.getUuid()) + ". Reason: " + e.getMessage() + ". Returned results may be behind the actual progress but not forward.";
                this.logger.warning(message, e);
                messages.add(message);
            }
        });
        return futures;
    }

    private void collectGarbage() {
        long currentTimeMillis = Clock.currentTimeMillis();
        UUID oldestUUID = null;
        long oldestCreationTime = Long.MAX_VALUE;
        Iterator<Map.Entry<UUID, WanSyncStatePerCluster>> it = this.store.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, WanSyncStatePerCluster> entry = it.next();
            UUID uuid = entry.getKey();
            WanSyncStatePerCluster syncState = entry.getValue();
            if (currentTimeMillis - syncState.creationTime > (long)MAX_STATE_LIFESPAN_MILLIS) {
                it.remove();
                this.logger.info("Sync progress information evicted for syncUUID: " + String.valueOf(uuid));
                continue;
            }
            if (oldestCreationTime <= syncState.creationTime) continue;
            oldestUUID = uuid;
        }
        if (this.store.size() > 100) {
            this.store.remove(oldestUUID);
            this.logger.info("Sync progress information evicted for syncUUID: " + String.valueOf(oldestUUID));
        }
    }

    private static final class WanSyncStatePerCluster {
        private final String wanReplicationName;
        private final String publisherId;
        private final long creationTime;
        private final Map<UUID, WanSyncStatePerMember> perMemberStates;

        WanSyncStatePerCluster(String wanReplicationName, String publisherId, long creationTime, Collection<UUID> memberUUIDs) {
            this.wanReplicationName = wanReplicationName;
            this.publisherId = publisherId;
            this.creationTime = creationTime;
            HashMap map = new HashMap(memberUUIDs.size());
            memberUUIDs.forEach(uuid -> map.put(uuid, new WanSyncStatePerMember()));
            this.perMemberStates = Collections.unmodifiableMap(map);
        }
    }

    public static final class WanSyncStatePerMember
    implements IdentifiedDataSerializable {
        private WanSyncStateStage stage = WanSyncStateStage.STARTED;
        private int progress;
        private transient Map<String, Float> mapToWeight;

        private synchronized void initializeWeight(Collection<String> mapNames, NodeEngine nodeEngine) {
            if (this.mapToWeight == null) {
                HashMap<String, Long> mapToLocalSize = new HashMap<String, Long>(mapNames.size());
                this.mapToWeight = new HashMap<String, Float>(mapNames.size());
                MapService mapService = (MapService)nodeEngine.getService("hz:impl:mapService");
                MapServiceContext mapServiceContext = mapService.getMapServiceContext();
                mapNames.forEach(mapName -> mapToLocalSize.put((String)mapName, 1L));
                for (IPartition partition : nodeEngine.getPartitionService().getPartitions()) {
                    if (!partition.isLocal()) continue;
                    PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(partition.getPartitionId());
                    for (String mapName2 : mapNames) {
                        RecordStore recordStore = partitionContainer.getExistingRecordStore(mapName2);
                        if (recordStore == null) continue;
                        mapToLocalSize.merge(mapName2, Long.valueOf(recordStore.size()), Long::sum);
                    }
                }
                long totalLocalSize = mapToLocalSize.values().stream().reduce(0L, Long::sum);
                mapToLocalSize.forEach((mapName, localSize) -> this.mapToWeight.put((String)mapName, Float.valueOf((float)localSize.longValue() / (float)totalLocalSize)));
                this.advanceStage(WanSyncStateStage.IN_PROGRESS);
            }
        }

        private synchronized <T extends WanSyncStats> void progressFromStats(Map<String, T> syncStatsMap) {
            if (this.isFinishedOrFailed()) {
                return;
            }
            int progress = 0;
            for (String mapName : this.mapToWeight.keySet()) {
                WanSyncStats syncStats = (WanSyncStats)syncStatsMap.get(mapName);
                int percentage = syncStats == null ? 0 : (syncStats.getPartitionsToSync() == 0 ? 100 : syncStats.getPartitionsSynced() * 100 / syncStats.getPartitionsToSync());
                progress = (int)((float)progress + (float)percentage * this.mapToWeight.get(mapName).floatValue());
            }
            this.progress = Math.max(progress, this.progress);
        }

        private synchronized void progressFromState(WanSyncStatePerMember state) {
            if (state == null) {
                return;
            }
            if (this.isFinishedOrFailed()) {
                return;
            }
            this.progress = Math.max(this.progress, state.progress);
            this.advanceStage(state.stage);
        }

        private synchronized boolean isFinishedOrFailed() {
            return this.stage.isTerminal();
        }

        private synchronized void advanceStage(WanSyncStateStage stageToAdvance) {
            this.stage = this.stage.advanceStage(stageToAdvance);
            if (this.stage == WanSyncStateStage.FINISHED) {
                this.progress = 100;
            }
        }

        @Override
        public synchronized void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.stage);
            out.writeInt(this.progress);
        }

        @Override
        public synchronized void readData(ObjectDataInput in) throws IOException {
            this.stage = (WanSyncStateStage)((Object)in.readObject());
            this.progress = in.readInt();
        }

        @Override
        public int getFactoryId() {
            return WanDataSerializerHook.F_ID;
        }

        @Override
        public int getClassId() {
            return 27;
        }
    }

    public static enum WanSyncStateStage {
        STARTED(0),
        IN_PROGRESS(1),
        FINISHED(2),
        FAILED(2);

        private final int order;

        private WanSyncStateStage(int order) {
            this.order = order;
        }

        private WanSyncStateStage advanceStage(WanSyncStateStage stageToAdvance) {
            return stageToAdvance.order > this.order ? stageToAdvance : this;
        }

        private WanSyncStateStage mergeStage(WanSyncStateStage stageToMerge) {
            if (stageToMerge == null) {
                return this;
            }
            int totalOrder = this.order + stageToMerge.order;
            if (totalOrder == 0) {
                return STARTED;
            }
            if (totalOrder < 4) {
                return IN_PROGRESS;
            }
            return this == FAILED ? this : stageToMerge;
        }

        public boolean isTerminal() {
            return this.order == 2;
        }

        public int getOrder() {
            return this.order;
        }
    }

    public static final class EnterpriseWanSyncStateResult
    implements WanSyncStateResult {
        private final WanSyncStatePerCluster clusterState;
        private final List<String> messages;
        private final WanSyncStateStage stage;
        private final int progress;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EnterpriseWanSyncStateResult(WanSyncStatePerCluster clusterState, List<String> messages) {
            this.clusterState = clusterState;
            this.messages = messages;
            WanSyncStateStage stage = null;
            int progress = 0;
            Iterator<WanSyncStatePerMember> iterator = clusterState.perMemberStates.values().iterator();
            while (iterator.hasNext()) {
                WanSyncStatePerMember memberState;
                WanSyncStatePerMember wanSyncStatePerMember = memberState = iterator.next();
                synchronized (wanSyncStatePerMember) {
                    stage = memberState.stage.mergeStage(stage);
                    progress += memberState.progress;
                }
            }
            this.stage = stage;
            this.progress = progress / clusterState.perMemberStates.size();
        }

        public WanSyncStateStage getStage() {
            return this.stage;
        }

        public int getProgress() {
            return this.progress;
        }

        @Override
        public JsonObject toJson() {
            JsonObject jResult = new JsonObject();
            if (!this.messages.isEmpty()) {
                JsonArray jMessages = new JsonArray();
                this.messages.forEach(jMessages::add);
                jResult.add("messages", jMessages);
            }
            jResult.add("stage", this.stage.toString());
            jResult.add("progress", this.progress);
            jResult.add("wanReplicationName", this.clusterState.wanReplicationName);
            jResult.add("wanPublisherId", this.clusterState.publisherId);
            jResult.add("creationTime", this.clusterState.creationTime);
            return jResult;
        }
    }
}

