/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.sync;

import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncStateManager;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.UUID;

public class WanSyncStateGetOperation
extends Operation
implements IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private UUID syncUUID;
    private WanSyncStateManager.WanSyncStatePerMember response;

    public WanSyncStateGetOperation() {
    }

    public WanSyncStateGetOperation(UUID syncUUID) {
        this.syncUUID = syncUUID;
    }

    @Override
    public void run() throws Exception {
        EnterpriseWanReplicationService wanReplicationService = (EnterpriseWanReplicationService)this.getService();
        WanSyncStateManager wanSyncStateManager = wanReplicationService.getSyncManager().getWanSyncStateManager();
        this.response = wanSyncStateManager.getLocalMemberState(this.syncUUID);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.syncUUID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.syncUUID = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 29;
    }

    @Override
    public String getServiceName() {
        return "hz:core:wanReplicationService";
    }
}

