/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.wan.impl.WanSyncStats;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class WanSyncContext<T extends WanSyncStats> {
    private static final long SYNC_STUCK_THRESHOLD_MILLIS = TimeUnit.HOURS.toMillis(1L);
    private final UUID uuid;
    private final Collection<String> mapNames;
    private final Map<String, Map<Integer, AtomicInteger>> counterMaps;
    private final Map<String, T> syncStatsMap;
    private final Collection<Integer> ownedPartitions;
    private final AtomicInteger mapsLeft;
    private volatile long lastAccess;

    WanSyncContext(UUID uuid, Collection<Integer> ownedPartitions, Collection<String> mapNames) {
        this.access();
        this.uuid = uuid;
        this.ownedPartitions = ownedPartitions;
        this.mapNames = mapNames;
        this.mapsLeft = new AtomicInteger(mapNames.size());
        this.counterMaps = MapUtil.createConcurrentHashMap(mapNames.size());
        this.syncStatsMap = MapUtil.createConcurrentHashMap(mapNames.size());
    }

    AtomicInteger getSyncCounter(String mapName, int partitionId) {
        this.access();
        Map counterMap = this.counterMaps.computeIfAbsent(mapName, k -> MapUtil.createConcurrentHashMap(this.ownedPartitions.size()));
        return counterMap.computeIfAbsent(partitionId, k -> new AtomicInteger());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    T getSyncStats(String mapName) {
        this.access();
        return (T)((WanSyncStats)this.syncStatsMap.get(mapName));
    }

    T addSyncStats(String mapName, T syncStats) {
        this.access();
        return (T)((WanSyncStats)this.syncStatsMap.put(mapName, syncStats));
    }

    Map<String, T> getSyncStatsMap() {
        return this.syncStatsMap;
    }

    Collection<String> getMapNames() {
        return this.mapNames;
    }

    void onMapSynced() {
        this.access();
        this.mapsLeft.decrementAndGet();
    }

    boolean isActive() {
        return System.currentTimeMillis() - this.lastAccess < SYNC_STUCK_THRESHOLD_MILLIS;
    }

    boolean isCompletedOrStuck() {
        return this.mapsLeft.get() == 0 || !this.isActive();
    }

    boolean isMapsLeft() {
        return this.mapsLeft.get() > 0;
    }

    Collection<Integer> getOwnedPartitions() {
        return this.ownedPartitions;
    }

    private void access() {
        this.lastAccess = System.currentTimeMillis();
    }

    public String toString() {
        return "WanSyncContext{uuid=" + String.valueOf(this.uuid) + ", mapNames=" + String.valueOf(this.mapNames) + ", counterMaps=" + String.valueOf(this.counterMaps) + ", syncStatsMap=" + String.valueOf(this.syncStatsMap) + ", ownedPartitions=" + String.valueOf(this.ownedPartitions) + ", mapsLeft=" + String.valueOf(this.mapsLeft) + ", lastAccess=" + this.lastAccess + "}";
    }
}

