/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.wan.impl.WanSyncStats;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WanMerkleTreeSyncStats
implements WanSyncStats {
    private final UUID uuid;
    @Probe(name="syncStartNanos", unit=ProbeUnit.NS)
    private final long syncStartNanos = System.nanoTime();
    @Probe(name="partitionsToSync")
    private final int partitionsToSync;
    @Probe(name="partitionsSynced")
    private final AtomicInteger partitionsSynced = new AtomicInteger();
    @Probe(name="recordsSynced")
    private final AtomicInteger recordsSynced = new AtomicInteger();
    @Probe(name="nodesSynced")
    private final AtomicInteger nodesSynced = new AtomicInteger();
    private final AtomicLong sumEntryCountSquares = new AtomicLong();
    @Probe(name="syncDurationNanos", unit=ProbeUnit.NS)
    private volatile long syncDurationNanos;
    @Probe(name="minLeafEntryCount")
    private volatile int minLeafEntryCount = Integer.MAX_VALUE;
    @Probe(name="maxLeafEntryCount")
    private volatile int maxLeafEntryCount = Integer.MIN_VALUE;
    @Probe(name="avgEntriesPerLeaf")
    private volatile double avgEntriesPerLeaf;
    @Probe(name="stdDevEntriesPerLeaf")
    private volatile double stdDevEntriesPerLeaf;

    WanMerkleTreeSyncStats(UUID uuid, int partitionsToSync) {
        this.uuid = uuid;
        this.partitionsToSync = partitionsToSync;
    }

    int onSyncPartition() {
        return this.partitionsSynced.incrementAndGet();
    }

    int onSyncPartitions(int syncedPartitionCount) {
        return this.partitionsSynced.addAndGet(syncedPartitionCount);
    }

    void onSyncLeaf(int leafEntryCount) {
        int recordsSynchronized = this.recordsSynced.addAndGet(leafEntryCount);
        int nodesSynchronized = this.nodesSynced.incrementAndGet();
        if (leafEntryCount < this.minLeafEntryCount) {
            this.minLeafEntryCount = leafEntryCount;
        }
        if (leafEntryCount > this.maxLeafEntryCount) {
            this.maxLeafEntryCount = leafEntryCount;
        }
        this.avgEntriesPerLeaf = nodesSynchronized != 0 ? (double)recordsSynchronized / (double)nodesSynchronized : 0.0;
        long sumSquares = this.sumEntryCountSquares.addAndGet((long)leafEntryCount * (long)leafEntryCount);
        double avgSquare = this.avgEntriesPerLeaf * this.avgEntriesPerLeaf;
        this.stdDevEntriesPerLeaf = Math.sqrt((double)sumSquares / (double)nodesSynchronized - avgSquare);
    }

    void onSyncComplete() {
        this.syncDurationNanos = System.nanoTime() - this.syncStartNanos;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public long getDurationSecs() {
        return TimeUnit.NANOSECONDS.toSeconds(this.syncDurationNanos);
    }

    @Override
    public int getPartitionsToSync() {
        return this.partitionsToSync;
    }

    @Override
    public int getPartitionsSynced() {
        return this.partitionsSynced.get();
    }

    @Override
    public int getRecordsSynced() {
        return this.recordsSynced.get();
    }

    public int getNodesSynced() {
        return this.nodesSynced.get();
    }

    public int getMinLeafEntryCount() {
        return this.partitionsToSync != 0 ? this.minLeafEntryCount : 0;
    }

    public int getMaxLeafEntryCount() {
        return this.partitionsToSync != 0 ? this.maxLeafEntryCount : 0;
    }

    public double getAvgEntriesPerLeaf() {
        return this.avgEntriesPerLeaf;
    }

    public double getStdDevEntriesPerLeaf() {
        return this.stdDevEntriesPerLeaf;
    }

    public String toString() {
        return "WanMerkleTreeSyncStats{uuid=" + String.valueOf(this.uuid) + ", syncStartNanos=" + this.syncStartNanos + ", partitionsToSync=" + this.partitionsToSync + ", partitionsSynced=" + String.valueOf(this.partitionsSynced) + ", recordsSynced=" + String.valueOf(this.recordsSynced) + ", nodesSynced=" + String.valueOf(this.nodesSynced) + ", sumEntryCountSquares=" + String.valueOf(this.sumEntryCountSquares) + ", syncDurationNanos=" + this.syncDurationNanos + ", minLeafEntryCount=" + this.minLeafEntryCount + ", maxLeafEntryCount=" + this.maxLeafEntryCount + ", avgEntriesPerLeaf=" + this.avgEntriesPerLeaf + ", stdDevEntriesPerLeaf=" + this.stdDevEntriesPerLeaf + "}";
    }
}

