/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cluster.Address;
import com.hazelcast.enterprise.wan.impl.replication.BatchReplicationStrategy;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SerialBatchReplicationStrategy
implements BatchReplicationStrategy {
    private final Set<Address> currentEndpointInvocations = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Int2ObjectHashMap<Address> partitionToEndpoint;
    private final Object partitionToEndpointLock = new Object();
    private int endpointIndexOffset;

    public SerialBatchReplicationStrategy(int partitionCount) {
        this.partitionToEndpoint = new Int2ObjectHashMap(partitionCount);
    }

    @Override
    public Address getNextEventBatchEndpoint(List<Address> endpoints) {
        if (endpoints.isEmpty()) {
            return null;
        }
        int endpointCount = endpoints.size();
        this.endpointIndexOffset = (this.endpointIndexOffset + 1) % endpointCount;
        for (int i = 0; i < endpointCount; ++i) {
            Address endpoint = endpoints.get((i + this.endpointIndexOffset) % endpointCount);
            if (!this.currentEndpointInvocations.add(endpoint)) continue;
            return endpoint;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean assignPartitionToEndpoint(Address address, int partition) {
        Object object = this.partitionToEndpointLock;
        synchronized (object) {
            Address previous = this.partitionToEndpoint.putIfAbsent(partition, address);
            return previous == null || previous.equals(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Address endpoint) {
        this.currentEndpointInvocations.remove(endpoint);
        Object object = this.partitionToEndpointLock;
        synchronized (object) {
            this.partitionToEndpoint.entrySet().removeIf(entry -> ((Address)entry.getValue()).equals(endpoint));
        }
    }

    @Override
    public int getFirstPartitionId(Address endpoint, List<Address> endpoints) {
        return endpoints.indexOf(endpoint);
    }

    @Override
    public int getPartitionIdStep(Address endpoint, List<Address> endpoints) {
        return endpoints.size();
    }

    @Override
    public boolean hasOngoingReplication() {
        return !this.currentEndpointInvocations.isEmpty();
    }

    public String toString() {
        return "SerialBatchReplicationStrategy{currentEndpointInvocations=" + String.valueOf(this.currentEndpointInvocations) + ", partitionToEndpoint=" + String.valueOf(this.partitionToEndpoint) + "}";
    }
}

