/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cluster.Address;
import com.hazelcast.enterprise.wan.impl.replication.BatchReplicationStrategy;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class ConcurrentBatchReplicationStrategy
implements BatchReplicationStrategy {
    static final int MAX_BATCH_COUNT_PER_ENDPOINT = 3;
    final Function<List<Address>, Integer> maxLimitFunction;
    final AtomicInteger concurrentInvocations = new AtomicInteger();
    private final Random random = new Random();

    public ConcurrentBatchReplicationStrategy(Function<List<Address>, Integer> maxLimitFunction) {
        this.maxLimitFunction = maxLimitFunction;
    }

    @Override
    public Address getNextEventBatchEndpoint(List<Address> endpoints) {
        int last;
        int max = this.maxLimitFunction.apply(endpoints);
        do {
            if ((last = this.concurrentInvocations.get()) < max) continue;
            return null;
        } while (!this.concurrentInvocations.compareAndSet(last, last + 1));
        return endpoints.get(this.random.nextInt(endpoints.size()));
    }

    @Override
    public boolean assignPartitionToEndpoint(Address address, int partitionId) {
        return true;
    }

    @Override
    public void complete(Address endpoint) {
        this.concurrentInvocations.decrementAndGet();
    }

    @Override
    public int getFirstPartitionId(Address endpoint, List<Address> endpoints) {
        return 0;
    }

    @Override
    public int getPartitionIdStep(Address endpoint, List<Address> endpoints) {
        return 1;
    }

    @Override
    public boolean hasOngoingReplication() {
        return this.concurrentInvocations.get() > 0;
    }

    public String toString() {
        return "ConcurrentBatchReplicationStrategy{concurrentInvocations=" + String.valueOf(this.concurrentInvocations) + "}";
    }
}

