/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.wan.WanEnterpriseCacheEvent;
import com.hazelcast.enterprise.wan.impl.operation.WanBaseOperation;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.ServiceNamespaceAware;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.io.IOException;

public class WanPutBackupOperation
extends WanBaseOperation
implements BackupOperation,
IdentifiedDataSerializable,
ServiceNamespaceAware {
    private ServiceNamespace objectNamespace;
    private InternalWanEvent event;

    public WanPutBackupOperation() {
    }

    public WanPutBackupOperation(String wanReplicationName, String targetName, InternalWanEvent event, ServiceNamespace namespace) {
        super(wanReplicationName, targetName);
        this.event = event;
        this.objectNamespace = namespace;
    }

    @Override
    public void run() throws Exception {
        this.getEWRService().getPublisherOrFail(this.wanReplicationName, this.wanPublisherId).publishRepublishedReplicationEventBackup(this.event);
        this.response = true;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.event);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.event = (InternalWanEvent)in.readObject();
    }

    @Override
    public ServiceNamespace getServiceNamespace() {
        if (this.objectNamespace != null) {
            return this.objectNamespace;
        }
        switch (this.event.getServiceName()) {
            case "hz:impl:mapService": {
                WanEnterpriseMapEvent mapEvent = (WanEnterpriseMapEvent)this.event;
                this.objectNamespace = MapService.getObjectNamespace(mapEvent.getMapName());
                break;
            }
            case "hz:impl:cacheService": {
                WanEnterpriseCacheEvent cacheEvent = (WanEnterpriseCacheEvent)this.event;
                this.objectNamespace = CacheService.getObjectNamespace(cacheEvent.getCacheName());
                break;
            }
            default: {
                throw new IllegalStateException("Forwarding WAN event for unknown service: " + this.event.getServiceName());
            }
        }
        return this.objectNamespace;
    }
}

