/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.wan.WanConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WanConsumerContainer {
    private final Node node;
    private final Map<String, WanConsumer> wanConsumers = new ConcurrentHashMap<String, WanConsumer>(2);

    public WanConsumerContainer(Node node) {
        this.node = node;
    }

    public void initializeCustomConsumers() {
        Map<String, WanReplicationConfig> configs = this.node.getConfig().getWanReplicationConfigs();
        if (configs != null) {
            for (Map.Entry<String, WanReplicationConfig> wanReplicationConfigEntry : configs.entrySet()) {
                WanConsumer consumer;
                WanConsumerConfig consumerConfig = wanReplicationConfigEntry.getValue().getConsumerConfig();
                if (consumerConfig == null || (consumer = ClassLoaderUtil.getOrCreate(consumerConfig.getImplementation(), this.node.getConfigClassLoader(), consumerConfig.getClassName())) == null) continue;
                this.node.getSerializationService().getManagedContext().initialize(consumer);
                consumer.init(wanReplicationConfigEntry.getKey(), consumerConfig);
                this.wanConsumers.put(wanReplicationConfigEntry.getKey(), consumer);
            }
        }
    }

    public void shutdown() {
        for (WanConsumer consumer : this.wanConsumers.values()) {
            consumer.shutdown();
        }
        this.wanConsumers.clear();
    }
}

