/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.Finalizer;
import com.hazelcast.enterprise.wan.impl.FinalizerAware;
import com.hazelcast.internal.util.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class TwoPhasedLinkedQueue<E extends FinalizerAware> {
    static final int DISABLED_FORCE_FINALIZATION_THRESHOLD = Integer.MAX_VALUE;
    private static final Finalizer NOOP_FINALIZER = () -> {};
    private Node<E> head;
    private Node<E> tail;
    private Node<E> finalizationHead;
    private final Object headLock = new Object();
    private final Object tailLock = new Object();
    private final Object finalizationHeadLock = new Object();
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger finalizables = new AtomicInteger();
    private final int forceFinalizationThreshold;

    TwoPhasedLinkedQueue() {
        this(Integer.MAX_VALUE);
    }

    TwoPhasedLinkedQueue(int forceFinalizationThreshold) {
        Preconditions.checkTrue(forceFinalizationThreshold > 1, "Force-finalization threshold should be greater than 1");
        this.forceFinalizationThreshold = forceFinalizationThreshold;
        Node<Object> initNode = new Node<Object>(null);
        this.finalizationHead = initNode;
        this.head = initNode;
        this.tail = initNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E value) {
        Object object = this.tailLock;
        synchronized (object) {
            Node<FinalizerAware> newTail = new Node<FinalizerAware>((FinalizerAware)Objects.requireNonNull(value));
            Node<E> oldTail = this.tail;
            this.tail = newTail;
            oldTail.next = newTail;
            this.size.getAndIncrement();
        }
        return true;
    }

    public E poll() {
        return this.dequeueInternalSinglePhased();
    }

    public E dequeue() {
        if (this.forceFinalizationThreshold == Integer.MAX_VALUE) {
            throw new IllegalStateException("The two-phased API cannot be used if force-finalization is disabled");
        }
        return this.dequeueInternalTwoPhased();
    }

    private E dequeueInternalSinglePhased() {
        Node<E> dequeued = this.dequeueInternal();
        if (dequeued == null) {
            return null;
        }
        this.finalizeNode(dequeued);
        return (E)((FinalizerAware)dequeued.value);
    }

    private E dequeueInternalTwoPhased() {
        Node<E> dequeued = this.dequeueInternal();
        if (dequeued == null) {
            return null;
        }
        FinalizerAware dequeuedValue = (FinalizerAware)dequeued.value;
        dequeuedValue.setFinalizer(() -> this.finalizeNode(dequeued));
        return (E)dequeuedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<E> dequeueInternal() {
        Object object = this.headLock;
        synchronized (object) {
            Node dequeued = this.head.next;
            if (dequeued == null) {
                return null;
            }
            this.finalizables.getAndIncrement();
            this.head = dequeued;
            this.size.getAndDecrement();
            dequeued.state = NodeState.CONSUMED;
            this.forceFinalizeIfNeeded();
            return dequeued;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceFinalizeIfNeeded() {
        if (this.forceFinalizationThreshold >= this.finalizables.get()) {
            return;
        }
        Object object = this.finalizationHeadLock;
        synchronized (object) {
            Node node = this.finalizationHead.next;
            if (this.forceFinalizationThreshold >= this.finalizables.get() || node.state == NodeState.OFFERED) {
                return;
            }
            this.finalizeNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeNode(Node<E> finalizedNode) {
        Object object = this.finalizationHeadLock;
        synchronized (object) {
            finalizedNode.state = NodeState.FINALIZED;
            Node node = this.finalizationHead.next;
            int finalized = 0;
            while (node != null && node.state == NodeState.FINALIZED) {
                ((FinalizerAware)node.value).setFinalizer(NOOP_FINALIZER);
                this.finalizationHead = node;
                node = node.next;
                ++finalized;
            }
            this.finalizables.addAndGet(-finalized);
        }
    }

    public int drainTo(Collection<E> drainTo, int elementsToDrain) {
        Objects.requireNonNull(drainTo);
        Preconditions.checkNotNegative(elementsToDrain, "The argument elementsToDrain must not be negative");
        boolean dequeued = true;
        int drained = 0;
        for (int i = 0; i < elementsToDrain && dequeued; ++i) {
            E dequeuedValue = this.dequeueInternalTwoPhased();
            boolean bl = dequeued = dequeuedValue != null;
            if (!dequeued) continue;
            drainTo.add(dequeuedValue);
            ++drained;
        }
        return drained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clear() {
        Object object = this.tailLock;
        synchronized (object) {
            Object object2 = this.headLock;
            synchronized (object2) {
                Object object3 = this.finalizationHeadLock;
                synchronized (object3) {
                    Node<Object> newNode = new Node<Object>(null);
                    this.tail = newNode;
                    Node<E> oldHead = this.head;
                    this.head = newNode;
                    this.finalizationHead = newNode;
                    int countCleared = 0;
                    Node<E> node = oldHead;
                    while (node != null) {
                        if (node != oldHead) {
                            ++countCleared;
                        }
                        node = node.next;
                    }
                    this.size.getAndAdd(-countCleared);
                    return countCleared;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consumeAll(Consumer<E> consumer) {
        Objects.requireNonNull(consumer);
        Object object = this.headLock;
        synchronized (object) {
            Object object2 = this.finalizationHeadLock;
            synchronized (object2) {
                Node fNode = this.finalizationHead.next;
                while (fNode != null && fNode.state != NodeState.OFFERED) {
                    consumer.accept((FinalizerAware)fNode.value);
                    fNode = fNode.next;
                }
                Node qNode = this.head.next;
                while (qNode != null) {
                    consumer.accept((FinalizerAware)qNode.value);
                    qNode = qNode.next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consumeAll(Consumer<E> queueConsumer, Consumer<E> finalizationConsumer) {
        Objects.requireNonNull(queueConsumer);
        Objects.requireNonNull(finalizationConsumer);
        Object object = this.headLock;
        synchronized (object) {
            Object object2 = this.finalizationHeadLock;
            synchronized (object2) {
                Node<E> fNode = this.finalizationHead;
                while ((fNode = fNode.next) != null && fNode.state != NodeState.OFFERED) {
                    finalizationConsumer.accept((FinalizerAware)fNode.value);
                }
                Node<E> qNode = this.head;
                while ((qNode = qNode.next) != null) {
                    queueConsumer.accept((FinalizerAware)qNode.value);
                }
            }
        }
    }

    public int size() {
        return this.size.get();
    }

    public int finalizables() {
        return this.finalizables.get();
    }

    private static class Node<E> {
        private Node<E> next;
        private final E value;
        private NodeState state = NodeState.OFFERED;

        Node(E value) {
            this.value = value;
        }

        public String toString() {
            return "Node{value=" + String.valueOf(this.value) + ", state=" + this.state.name() + "}";
        }
    }

    private static enum NodeState {
        OFFERED,
        CONSUMED,
        FINALIZED;

    }
}

