/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.FinalizableEnterpriseWanEvent;
import com.hazelcast.enterprise.wan.impl.PartitionWanEventQueueMap;
import com.hazelcast.enterprise.wan.impl.WanEventQueue;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class PartitionWanEventContainer {
    private final PartitionWanEventQueueMap mapWanEventQueueMap;
    private final PartitionWanEventQueueMap cacheWanEventQueueMap;
    private PartitionWanEventQueueMap current;
    private PartitionWanEventQueueMap next;

    public PartitionWanEventContainer(int maxInFlightEvents) {
        this.mapWanEventQueueMap = new PartitionWanEventQueueMap(maxInFlightEvents);
        this.cacheWanEventQueueMap = new PartitionWanEventQueueMap(maxInFlightEvents);
        this.current = this.mapWanEventQueueMap;
        this.next = this.cacheWanEventQueueMap;
    }

    public boolean publishMapWanEvent(String mapName, FinalizableEnterpriseWanEvent event) {
        return this.mapWanEventQueueMap.offerEvent(event, mapName, event.getBackupCount());
    }

    public InternalWanEvent pollMapWanEvent(String mapName) {
        return this.mapWanEventQueueMap.pollEvent(mapName);
    }

    public InternalWanEvent pollCacheWanEvent(String cacheName) {
        return this.cacheWanEventQueueMap.pollEvent(cacheName);
    }

    public void drainRandomWanQueue(Collection<FinalizableEnterpriseWanEvent> drainTo, int elementsToDrain) {
        int drained = this.drainRandomWanQueue(this.current, drainTo, elementsToDrain);
        if (drained == 0) {
            PartitionWanEventQueueMap temp = this.current;
            this.current = this.next;
            this.next = temp;
        } else {
            this.drainRandomWanQueue(this.next, drainTo, elementsToDrain);
        }
    }

    public int size() {
        return this.size(false);
    }

    public int size(boolean includeFinalizables) {
        return this.getSizeFromCacheOrMap(includeFinalizables, this.cacheWanEventQueueMap) + this.getSizeFromCacheOrMap(includeFinalizables, this.mapWanEventQueueMap);
    }

    private int getSizeFromCacheOrMap(boolean includeFinalizables, PartitionWanEventQueueMap map) {
        int size = 0;
        for (WanEventQueue eventQueue : map.values()) {
            if (eventQueue == null) continue;
            size += eventQueue.size();
            if (!includeFinalizables) continue;
            size += eventQueue.finalizables();
        }
        return size;
    }

    private int drainRandomWanQueue(PartitionWanEventQueueMap eventQueueMap, Collection<FinalizableEnterpriseWanEvent> drainTo, int elementsToDrain) {
        for (WanEventQueue eventQueue : eventQueueMap.values()) {
            int drained;
            if (eventQueue == null || (drained = eventQueue.drainTo(drainTo, elementsToDrain)) <= 0) continue;
            return drained;
        }
        return 0;
    }

    public PartitionWanEventQueueMap getMapEventQueueMapByBackupCount(int backupCount) {
        return this.getEventQueueMapByBackupCount(this.mapWanEventQueueMap, backupCount);
    }

    public PartitionWanEventQueueMap getCacheEventQueueMapByBackupCount(int backupCount) {
        return this.getEventQueueMapByBackupCount(this.cacheWanEventQueueMap, backupCount);
    }

    private PartitionWanEventQueueMap getEventQueueMapByBackupCount(PartitionWanEventQueueMap wanEventQueueMap, int backupCount) {
        PartitionWanEventQueueMap filteredEventQueueMap = new PartitionWanEventQueueMap();
        for (Map.Entry entry : wanEventQueueMap.entrySet()) {
            String name = (String)entry.getKey();
            WanEventQueue queue = (WanEventQueue)entry.getValue();
            if (queue.getBackupCount() < backupCount) continue;
            filteredEventQueueMap.put(name, queue);
        }
        return filteredEventQueueMap;
    }

    public boolean publishCacheWanEvent(String cacheName, FinalizableEnterpriseWanEvent event) {
        return this.cacheWanEventQueueMap.offerEvent(event, cacheName, event.getBackupCount());
    }

    public void clear() {
        this.mapWanEventQueueMap.clear();
        this.cacheWanEventQueueMap.clear();
    }

    int drainMap(Predicate<WanEventQueue> predicate) {
        return this.drain(this.mapWanEventQueueMap, predicate);
    }

    int drainCache(Predicate<WanEventQueue> predicate) {
        return this.drain(this.cacheWanEventQueueMap, predicate);
    }

    private int drain(PartitionWanEventQueueMap queueMap, Predicate<WanEventQueue> predicate) {
        int size = 0;
        for (Map.Entry eventQueueMapEntry : queueMap.entrySet()) {
            WanEventQueue eventQueue = (WanEventQueue)eventQueueMapEntry.getValue();
            if (eventQueue == null || !predicate.test(eventQueue)) continue;
            size += eventQueue.clear();
        }
        return size;
    }
}

