/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

public class DistributedObjectIdentifier {
    private final String serviceName;
    private final String objectName;
    private final int totalBackupCount;

    public DistributedObjectIdentifier(String serviceName, String objectName, int totalBackupCount) {
        this.serviceName = serviceName;
        this.objectName = objectName;
        this.totalBackupCount = totalBackupCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedObjectIdentifier that = (DistributedObjectIdentifier)o;
        if (this.totalBackupCount != that.totalBackupCount) {
            return false;
        }
        if (!this.serviceName.equals(that.serviceName)) {
            return false;
        }
        return this.objectName.equals(that.objectName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getTotalBackupCount() {
        return this.totalBackupCount;
    }

    public int hashCode() {
        int result = this.serviceName.hashCode();
        result = 31 * result + this.objectName.hashCode();
        result = 31 * result + this.totalBackupCount;
        return result;
    }

    public String toString() {
        return "DistributedObjectIdentifier{serviceName='" + this.serviceName + "', objectName='" + this.objectName + "', totalBackupCount=" + this.totalBackupCount + "}";
    }
}

