/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.task;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.dto.TriggerLeaderElection;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.cp.internal.raft.impl.state.LeaderState;
import com.hazelcast.cp.internal.raft.impl.state.LeadershipTransferState;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;

public class LeadershipTransferTask
implements Runnable {
    private final RaftNodeImpl raftNode;
    private final int retryCount;
    private final int maxRetryCount;

    LeadershipTransferTask(RaftNodeImpl raftNode, int maxRetryCount) {
        this(raftNode, 0, maxRetryCount);
    }

    private LeadershipTransferTask(RaftNodeImpl raftNode, int retryCount, int maxRetryCount) {
        this.raftNode = raftNode;
        this.retryCount = retryCount;
        this.maxRetryCount = maxRetryCount;
    }

    @Override
    public void run() {
        ILogger logger = this.raftNode.getLogger(this.getClass());
        RaftState state = this.raftNode.state();
        LeaderState leaderState = state.leaderState();
        if (leaderState == null) {
            logger.fine("Not retrying leadership transfer since not leader...");
            return;
        }
        LeadershipTransferState leadershipTransferState = state.leadershipTransferState();
        Preconditions.checkTrue(leadershipTransferState != null, "No leadership transfer state!");
        if (this.retryCount == this.maxRetryCount) {
            String msg = "Leadership transfer to " + String.valueOf(leadershipTransferState.endpoint()) + " timed out!";
            logger.warning(msg);
            state.completeLeadershipTransfer(new IllegalStateException(msg));
            return;
        }
        RaftEndpoint targetEndpoint = leadershipTransferState.endpoint();
        if (state.commitIndex() < state.log().lastLogOrSnapshotIndex()) {
            logger.warning("Waiting until all appended entries to be committed before transferring leadership to " + String.valueOf(targetEndpoint));
            this.reschedule();
            return;
        }
        if (this.retryCount > 0) {
            logger.fine("Retrying leadership transfer to " + String.valueOf(leadershipTransferState.endpoint()));
        } else {
            logger.info("Transferring leadership to " + String.valueOf(leadershipTransferState.endpoint()));
        }
        leaderState.getFollowerState(targetEndpoint).resetRequestBackoff();
        this.raftNode.sendAppendRequest(targetEndpoint);
        LogEntry entry = state.log().lastLogOrSnapshotEntry();
        this.raftNode.send(new TriggerLeaderElection(this.raftNode.getLocalMember(), state.term(), entry.term(), entry.index()), targetEndpoint);
        this.reschedule();
    }

    private void reschedule() {
        long delayMillis = Math.max(1L, this.raftNode.getLeaderElectionTimeoutInMillis() * 2L / (long)this.maxRetryCount);
        this.raftNode.schedule(new LeadershipTransferTask(this.raftNode, this.retryCount + 1, this.maxRetryCount), delayMillis);
    }
}

