/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.state;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class RaftGroupMembers {
    private final long index;
    private final Collection<RaftEndpoint> members;
    private final Collection<RaftEndpoint> remoteMembers;

    public RaftGroupMembers(long index, Collection<RaftEndpoint> endpoints, RaftEndpoint localEndpoint) {
        this.index = index;
        this.members = Collections.unmodifiableSet(new LinkedHashSet<RaftEndpoint>(endpoints));
        LinkedHashSet<RaftEndpoint> remoteMembers = new LinkedHashSet<RaftEndpoint>(endpoints);
        remoteMembers.remove(localEndpoint);
        this.remoteMembers = Collections.unmodifiableSet(remoteMembers);
    }

    public long index() {
        return this.index;
    }

    public Collection<RaftEndpoint> members() {
        return this.members;
    }

    public Collection<RaftEndpoint> remoteMembers() {
        return this.remoteMembers;
    }

    public int memberCount() {
        return this.members.size();
    }

    public int majority() {
        return this.members.size() / 2 + 1;
    }

    public boolean isKnownMember(RaftEndpoint endpoint) {
        return this.members.contains(endpoint);
    }

    public String toString() {
        return "RaftGroupMembers{index=" + this.index + ", members=" + String.valueOf(this.members) + "}";
    }
}

