/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.state;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.state.FollowerState;
import com.hazelcast.cp.internal.raft.impl.state.QueryState;
import com.hazelcast.internal.util.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LeaderState {
    private final Map<RaftEndpoint, FollowerState> followerStates = new HashMap<RaftEndpoint, FollowerState>();
    private final QueryState queryState = new QueryState();
    private long flushedLogIndex;

    LeaderState(Collection<RaftEndpoint> remoteMembers, long lastLogIndex) {
        for (RaftEndpoint follower : remoteMembers) {
            this.followerStates.put(follower, new FollowerState(0L, lastLogIndex + 1L));
        }
        this.flushedLogIndex = lastLogIndex;
    }

    public void add(RaftEndpoint follower, long lastLogIndex) {
        assert (!this.followerStates.containsKey(follower)) : "Already known follower " + String.valueOf(follower);
        this.followerStates.put(follower, new FollowerState(0L, lastLogIndex + 1L));
    }

    public void remove(RaftEndpoint follower) {
        FollowerState removed = this.followerStates.remove(follower);
        this.queryState.removeAck(follower);
        assert (removed != null) : "Unknown follower " + String.valueOf(follower);
    }

    public long[] matchIndices() {
        long[] indices = new long[this.followerStates.size() + 1];
        int ix = 0;
        for (FollowerState state : this.followerStates.values()) {
            indices[ix++] = state.matchIndex();
        }
        return indices;
    }

    public FollowerState getFollowerState(RaftEndpoint follower) {
        FollowerState followerState = this.followerStates.get(follower);
        assert (followerState != null) : "Unknown follower " + String.valueOf(follower);
        return followerState;
    }

    public Map<RaftEndpoint, FollowerState> getFollowerStates() {
        return this.followerStates;
    }

    public QueryState queryState() {
        return this.queryState;
    }

    public long queryRound() {
        return this.queryState.queryRound();
    }

    public void flushedLogIndex(long flushedLogIndex) {
        assert (flushedLogIndex > this.flushedLogIndex);
        this.flushedLogIndex = flushedLogIndex;
    }

    public long flushedLogIndex() {
        return this.flushedLogIndex;
    }

    public long majorityAppendRequestAckTimestamp(int majority) {
        long[] ackTimes = new long[this.followerStates.size() + 1];
        int i = 0;
        ackTimes[i] = Clock.currentTimeMillis();
        for (FollowerState followerState : this.followerStates.values()) {
            ackTimes[++i] = followerState.appendRequestAckTimestamp();
        }
        Arrays.sort(ackTimes);
        return ackTimes[ackTimes.length - majority];
    }
}

