/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.handler;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.RaftRole;
import com.hazelcast.cp.internal.raft.impl.dto.VoteResponse;
import com.hazelcast.cp.internal.raft.impl.handler.AbstractResponseHandlerTask;
import com.hazelcast.cp.internal.raft.impl.state.CandidateState;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;

public class VoteResponseHandlerTask
extends AbstractResponseHandlerTask {
    private final VoteResponse resp;

    public VoteResponseHandlerTask(RaftNodeImpl raftNode, VoteResponse response) {
        super(raftNode);
        this.resp = response;
    }

    @Override
    protected void handleResponse() {
        RaftState state = this.raftNode.state();
        if (state.role() != RaftRole.CANDIDATE) {
            this.logger.info("Ignored " + String.valueOf(this.resp) + ". We are not CANDIDATE anymore.");
            return;
        }
        if (this.resp.term() > state.term()) {
            this.logger.info("Demoting to FOLLOWER from current term: " + state.term() + " to new term: " + this.resp.term() + " after " + String.valueOf(this.resp));
            this.raftNode.toFollower(this.resp.term());
            return;
        }
        if (this.resp.term() < state.term()) {
            this.logger.warning("Stale " + String.valueOf(this.resp) + " is received, current term: " + state.term());
            return;
        }
        CandidateState candidateState = state.candidateState();
        if (this.resp.granted() && candidateState.grantVote(this.resp.voter())) {
            this.logger.info("Vote granted from " + String.valueOf(this.resp.voter()) + " for term: " + state.term() + ", number of votes: " + candidateState.voteCount() + ", majority: " + candidateState.majority());
        }
        if (candidateState.isMajorityGranted()) {
            this.logger.info("We are the LEADER!");
            this.raftNode.toLeader();
        }
    }

    @Override
    protected RaftEndpoint sender() {
        return this.resp.voter();
    }
}

