/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.internal.persistence.BufferedRaf;
import com.hazelcast.cp.internal.persistence.FileIOSupport;
import com.hazelcast.cp.internal.persistence.LogEntryRingBuffer;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.cp.internal.raft.impl.persistence.LogFileStructure;
import com.hazelcast.cp.internal.raft.impl.persistence.RaftStateStore;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.FixedBufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OnDiskRaftStateStore
implements RaftStateStore {
    static final String RAFT_LOG_PREFIX = "raftlog-";
    static final String MEMBERS_FILENAME = "members";
    static final String TERM_FILENAME = "term";
    private final File baseDir;
    private final InternalSerializationService serializationService;
    private final LogEntryRingBuffer logEntryRingBuffer;
    private final FixedBufferObjectDataOutput entryDataOut;
    private BufferedRaf logRaf;
    private BufferedRaf.BufRafObjectDataOut logDataOut;
    private boolean flushCalledOnCurrFile;
    private File currentFile;
    private File danglingFile;
    private long nextEntryIndex;

    public OnDiskRaftStateStore(@Nonnull File baseDir, @Nonnull InternalSerializationService serializationService, int maxUncommittedEntries, @Nullable LogFileStructure logFileStructure) {
        this.baseDir = baseDir;
        this.serializationService = serializationService;
        if (logFileStructure != null) {
            long[] tailEntryOffsets = logFileStructure.tailEntryOffsets();
            this.nextEntryIndex = logFileStructure.indexOfFirstTailEntry() + (long)tailEntryOffsets.length;
            this.logEntryRingBuffer = new LogEntryRingBuffer(maxUncommittedEntries, logFileStructure);
            this.currentFile = new File(baseDir, logFileStructure.filename());
        } else {
            this.nextEntryIndex = 1L;
            this.logEntryRingBuffer = new LogEntryRingBuffer(maxUncommittedEntries);
        }
        this.entryDataOut = new FixedBufferObjectDataOutput(16384, serializationService, serializationService.getByteOrder());
    }

    @Override
    public void open() throws IOException {
        if (!(this.baseDir.exists() || this.baseDir.mkdir() || this.baseDir.exists())) {
            throw new IOException("Cannot create directory " + this.baseDir.getAbsolutePath());
        }
        if (this.currentFile == null) {
            this.currentFile = this.fileWithIndex(this.nextEntryIndex);
        }
        this.logRaf = OnDiskRaftStateStore.openForAppend(this.currentFile);
        this.logDataOut = this.newObjectDataOutput(this.logRaf);
    }

    @Override
    public void persistEntry(@Nonnull LogEntry entry) throws IOException {
        if (entry.index() != this.nextEntryIndex) {
            throw new IllegalArgumentException(String.format("Expected entry index %,d, but got %,d (%s)", this.nextEntryIndex, entry.index(), entry.toString()));
        }
        this.logEntryRingBuffer.addEntryOffset(this.logRaf.filePointer());
        this.writeEntry(this.logRaf, this.logDataOut, entry);
        ++this.nextEntryIndex;
    }

    @Override
    public void persistSnapshot(@Nonnull SnapshotEntry snapshot) throws IOException {
        File newFile = this.fileWithIndex(snapshot.index());
        BufferedRaf newRaf = OnDiskRaftStateStore.openForAppend(newFile);
        BufferedRaf.BufRafObjectDataOut newDataOut = this.newObjectDataOutput(newRaf);
        this.writeEntry(newRaf, newDataOut, snapshot);
        long newStartOffset = newRaf.filePointer();
        if (this.logEntryRingBuffer.topIndex() > snapshot.index()) {
            long copyFromOffset = this.logEntryRingBuffer.getEntryOffset(snapshot.index() + 1L);
            this.logRaf.seek(copyFromOffset);
            this.logRaf.copyTo(newRaf);
        }
        this.logRaf.close();
        this.logRaf = newRaf;
        this.logDataOut = newDataOut;
        this.logEntryRingBuffer.adjustToNewFile(newStartOffset, snapshot.index());
        this.nextEntryIndex = Math.max(this.nextEntryIndex, snapshot.index() + 1L);
        if (this.flushCalledOnCurrFile) {
            this.danglingFile = this.currentFile;
            this.flushCalledOnCurrFile = false;
        } else {
            IOUtil.delete(this.currentFile);
        }
        this.currentFile = newFile;
    }

    private void writeEntry(BufferedRaf raf, BufferedRaf.BufRafObjectDataOut dataOut, LogEntry entry) throws IOException {
        this.entryDataOut.clear();
        this.entryDataOut.writeObject(entry);
        int length = this.entryDataOut.position();
        raf.writeInt(length);
        if (length > this.entryDataOut.capacity()) {
            dataOut.writeObject(entry);
        } else {
            dataOut.write(this.entryDataOut.getBuffer(), 0, length);
        }
        dataOut.writeCrc32();
    }

    @Override
    public void deleteEntriesFrom(long startIndexInclusive) throws IOException {
        long rollbackOffset = this.logEntryRingBuffer.deleteEntriesFrom(startIndexInclusive);
        this.logRaf.seek(rollbackOffset);
        this.logRaf.setLength(rollbackOffset);
        this.nextEntryIndex = startIndexInclusive;
    }

    @Override
    public void persistInitialMembers(@Nonnull RaftEndpoint localMember, @Nonnull Collection<RaftEndpoint> initialMembers) throws IOException {
        this.runWrite(MEMBERS_FILENAME, out -> {
            out.writeObject(localMember);
            SerializationUtil.writeCollection(initialMembers, out);
        });
    }

    @Override
    public void persistTerm(int term, @Nullable RaftEndpoint votedFor) throws IOException {
        this.runWrite(TERM_FILENAME, out -> {
            out.writeInt(term);
            out.writeObject(votedFor);
        });
    }

    @Override
    public void flushLogs() throws IOException {
        this.logDataOut.flush();
        this.logRaf.force();
        this.flushCalledOnCurrFile = true;
        if (this.danglingFile != null) {
            IOUtil.delete(this.danglingFile);
            this.danglingFile = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.flushLogs();
        this.logRaf.close();
    }

    @Nonnull
    private BufferedRaf.BufRafObjectDataOut newObjectDataOutput(BufferedRaf bufRaf) {
        return bufRaf.asObjectDataOutputStream(this.serializationService);
    }

    @Nonnull
    private File fileWithIndex(long entryIndex) {
        File newFile = new File(this.baseDir, OnDiskRaftStateStore.getRaftLogFileName(entryIndex));
        if (this.currentFile != null && this.currentFile.getName().equals(newFile.getName())) {
            throw new IllegalArgumentException("invalid index: " + entryIndex + " for new file!");
        }
        return newFile;
    }

    private void runWrite(String filename, FileIOSupport.Writable writable) throws IOException {
        FileIOSupport.writeWithChecksum(this.baseDir, filename, this.serializationService, writable);
    }

    @Nonnull
    private static BufferedRaf openForAppend(File file) throws IOException {
        BufferedRaf raf = new BufferedRaf(new RandomAccessFile(file, "rw"));
        raf.seek(raf.length());
        return raf;
    }

    @Nonnull
    static String getRaftLogFileName(long entryIndex) {
        return String.format("raftlog-%016x", entryIndex);
    }
}

