/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftInvocationManager;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.persistence.CPMetadataStore;
import com.hazelcast.cp.internal.persistence.CPMetadataStoreImpl;
import com.hazelcast.cp.internal.persistence.CPPersistenceService;
import com.hazelcast.cp.internal.persistence.OnDiskRaftStateLoader;
import com.hazelcast.cp.internal.persistence.OnDiskRaftStateStore;
import com.hazelcast.cp.internal.persistence.operation.PublishLocalCPMemberOp;
import com.hazelcast.cp.internal.persistence.operation.PublishRestoredCPMembersOp;
import com.hazelcast.cp.internal.persistence.raftop.VerifyRestartedCPMemberOp;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.persistence.LogFileStructure;
import com.hazelcast.cp.internal.raft.impl.persistence.RaftStateStore;
import com.hazelcast.cp.internal.raft.impl.persistence.RestoredRaftState;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.DirectoryLock;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CPPersistenceServiceImpl
implements CPPersistenceService {
    public static final HazelcastProperty FAVOR_OWN_PERSISTENCE_DIRECTORY = new HazelcastProperty("hazelcast.cp.persistence.favor.own.directory", true);
    public static final HazelcastProperty ALLOW_IP_ADDRESS_CHANGE = new HazelcastProperty("hazelcast.cp.persistence.allow.ip.change", true);
    private static final int PUBLISH_CP_MEMBERS_MILLIS = 250;
    private final Node node;
    private final File dir;
    private final CPMetadataStoreImpl metadataStore;
    private final ILogger logger;
    private final boolean allowIpAddressChange;
    private final DirectoryLock directoryLock;
    private final InternalSerializationService serializationService;
    private final CPSubsystemConfig cpSubsystemConfig;
    private volatile boolean startCompleted;
    private volatile CPMemberInfo localCPMember;

    public CPPersistenceServiceImpl(Node node) {
        this.node = node;
        this.logger = node.getLogger(this.getClass());
        this.serializationService = node.getSerializationService();
        this.allowIpAddressChange = node.getProperties().getBoolean(ALLOW_IP_ADDRESS_CHANGE);
        this.directoryLock = this.acquireDir(node.getConfig().getCPSubsystemConfig());
        this.dir = this.directoryLock.getDir();
        this.metadataStore = new CPMetadataStoreImpl(this.dir, this.serializationService);
        this.cpSubsystemConfig = node.getConfig().getCPSubsystemConfig();
    }

    private DirectoryLock acquireDir(CPSubsystemConfig config) {
        File baseDir = config.getBaseDir();
        if (!(baseDir.exists() || baseDir.mkdirs() || baseDir.exists())) {
            throw new HazelcastException("Could not create " + baseDir.getAbsolutePath());
        }
        if (!baseDir.isDirectory()) {
            throw new HazelcastException(baseDir.getAbsolutePath() + " is not a directory!");
        }
        File[] dirs = baseDir.listFiles(f -> {
            if (f.isFile()) {
                return false;
            }
            boolean cpDirectory = CPMetadataStoreImpl.isCPDirectory(f);
            if (!cpDirectory) {
                this.verifyNoCPGroupDirExists(f);
                this.logger.fine(f.getAbsolutePath() + " is not a valid CP data directory.");
            } else {
                try {
                    CPMemberInfo cpMember = new CPMetadataStoreImpl(f, this.serializationService).readLocalCPMember();
                    if (cpMember == null) {
                        this.verifyNoCPGroupDirExists(f);
                    }
                }
                catch (IOException e) {
                    throw new HazelcastException("Could not read local CP member file in " + f.getAbsolutePath(), e);
                }
            }
            return cpDirectory;
        });
        if (dirs == null) {
            return this.createNewDir(baseDir);
        }
        if (this.node.getProperties().getBoolean(FAVOR_OWN_PERSISTENCE_DIRECTORY)) {
            Arrays.sort(dirs, new OwnDirComparator());
        }
        for (File dir : dirs) {
            try {
                block11: {
                    block10: {
                        if (this.allowIpAddressChange) break block10;
                        CPMemberInfo member = new CPMetadataStoreImpl(dir, this.serializationService).readLocalCPMember();
                        if (!this.node.getThisAddress().equals(member.getAddress())) break block11;
                    }
                    DirectoryLock directoryLock = DirectoryLock.lockForDirectory(dir, this.logger);
                    this.logger.info("Found existing CP data directory: " + dir.getAbsolutePath());
                    return directoryLock;
                }
                this.logger.fine("This directory does not belong to us: " + dir.getAbsolutePath());
            }
            catch (Exception e) {
                this.logger.fine("Could not lock existing CP data directory: " + dir.getAbsolutePath() + ". Reason: " + e.getMessage());
            }
        }
        return this.createNewDir(baseDir);
    }

    private DirectoryLock createNewDir(File baseDir) {
        File dir = new File(baseDir, UuidUtil.newUnsecureUuidString());
        boolean created = dir.mkdir();
        assert (created) : "Couldn't create " + dir.getAbsolutePath();
        this.logger.info("Created new empty CP data directory: " + dir.getAbsolutePath());
        return DirectoryLock.lockForDirectory(dir, this.logger);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public CPMetadataStore getCPMetadataStore() {
        return this.metadataStore;
    }

    @Override
    @Nonnull
    public RaftStateStore createRaftStateStore(@Nonnull RaftGroupId groupId, @Nullable LogFileStructure logFileStructure) {
        File groupDir = this.getGroupDir(groupId);
        int maxUncommittedEntries = this.cpSubsystemConfig.getRaftAlgorithmConfig().getUncommittedEntryCountToRejectNewAppends() + 1;
        return new OnDiskRaftStateStore(groupDir, this.node.getSerializationService(), maxUncommittedEntries, logFileStructure);
    }

    @Override
    public void removeRaftStateStore(@Nonnull RaftGroupId groupId) {
        File groupDir = this.getGroupDir(groupId);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Deleting directory " + String.valueOf(groupDir) + " and its contents " + Arrays.toString(groupDir.list()));
        }
        IOUtil.delete(groupDir);
    }

    @Override
    public void reset() {
        File[] files = this.dir.listFiles((dir, name) -> !"lock".equals(name));
        if (files != null) {
            Arrays.sort(files, (f1, f2) -> {
                if (CPMetadataStoreImpl.isCPMemberFile(this.dir, f1.getName())) {
                    return -1;
                }
                if (CPMetadataStoreImpl.isCPMemberFile(this.dir, f2.getName())) {
                    return 1;
                }
                if (CPMetadataStoreImpl.isMetadataGroupIdFile(this.dir, f1.getName())) {
                    return 1;
                }
                if (CPMetadataStoreImpl.isMetadataGroupIdFile(this.dir, f2.getName())) {
                    return -1;
                }
                return 0;
            });
            for (File f : files) {
                IOUtil.delete(f);
            }
        }
    }

    public void start() {
        boolean addressChangeDetected;
        this.logger.info("Starting CP restore process in " + this.dir.getAbsolutePath());
        RaftService raftService = (RaftService)this.node.getNodeEngine().getService("hz:core:raft");
        try {
            RaftGroupId metadataGroupId = this.metadataStore.readMetadataGroupId();
            if (metadataGroupId != null) {
                raftService.getMetadataGroupManager().restoreMetadataGroupId(metadataGroupId);
            }
        }
        catch (IOException e) {
            throw new HazelcastException(e);
        }
        try {
            this.localCPMember = this.metadataStore.readLocalCPMember();
            if (this.localCPMember == null) {
                this.verifyNoCPGroupDirExists(this.dir);
                this.logger.info("Nothing to restore in " + this.dir.getAbsolutePath());
                this.startCompleted = true;
                return;
            }
            boolean bl = addressChangeDetected = !this.node.getThisAddress().equals(this.localCPMember.getAddress());
            if (addressChangeDetected) {
                this.logger.warning("IP address change detected! " + String.valueOf(this.localCPMember.getAddress()) + " -> " + String.valueOf(this.node.getThisAddress()));
                assert (this.allowIpAddressChange) : "IP address change is now allowed!";
                this.localCPMember = new CPMemberInfo(this.localCPMember.getUuid(), this.node.getThisAddress());
            }
        }
        catch (IOException e) {
            throw new HazelcastException(e);
        }
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        InternalCompletableFuture verificationFuture = new InternalCompletableFuture();
        if (addressChangeDetected) {
            this.runAsync("cp-local-member-address-publish-thread", () -> this.publishLocalAddressChange(verificationFuture));
        }
        this.runAsync("notify-metadata-group-thread", () -> this.verifyRestartedCPMember(verificationFuture));
        File[] groupDirs = this.getGroupDirs(this.dir);
        if (groupDirs == null || groupDirs.length == 0) {
            this.logger.info("No CP group to restore in " + this.dir.getAbsolutePath());
        } else {
            ExecutionService executionService = this.node.getNodeEngine().getExecutionService();
            for (File groupDir : groupDirs) {
                Future<Void> f = executionService.submit("hz:async", new RestoreCPGroupTask(groupDir, raftService));
                futures.add(f);
            }
        }
        futures.add(verificationFuture);
        FutureUtil.waitWithDeadline(futures, this.cpSubsystemConfig.getDataLoadTimeoutSeconds(), TimeUnit.SECONDS, FutureUtil.RETHROW_EVERYTHING);
        this.startCompleted = true;
        this.logger.fine("CP restore completed...");
    }

    private void verifyNoCPGroupDirExists(File dir) {
        Preconditions.checkTrue(dir.isDirectory(), dir.getAbsolutePath() + " is not a directory!");
        File[] groupDirs = this.getGroupDirs(dir);
        if (groupDirs != null && groupDirs.length > 0) {
            List invalidDirNames = Arrays.stream(groupDirs).map(File::getName).collect(Collectors.toList());
            throw new IllegalStateException(dir.getAbsolutePath() + " contains CP group directories: " + String.valueOf(invalidDirNames) + " without CP member identity file!");
        }
    }

    private void publishLocalAddressChange(Future<Void> futureToCheck) {
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        OperationServiceImpl operationService = nodeEngine.getOperationService();
        ClusterService clusterService = nodeEngine.getClusterService();
        RaftService raftService = (RaftService)this.node.getNodeEngine().getService("hz:core:raft");
        while (!futureToCheck.isDone()) {
            raftService.getInvocationManager().getRaftInvocationContext().updateMember(this.localCPMember);
            this.logger.fine("Broadcasting local CP member... " + String.valueOf(this.localCPMember));
            PublishLocalCPMemberOp op = new PublishLocalCPMemberOp(this.localCPMember);
            for (Member member : clusterService.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR)) {
                operationService.send(op, member.getAddress());
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private void verifyRestartedCPMember(CompletableFuture<Void> future) {
        RaftService raftService = (RaftService)this.node.getNodeEngine().getService("hz:core:raft");
        RaftInvocationManager invocationManager = raftService.getInvocationManager();
        try {
            invocationManager.invoke(raftService.getMetadataGroupId(), new VerifyRestartedCPMemberOp(this.localCPMember)).join();
            this.logger.info(String.valueOf(this.localCPMember) + " is verified on the METADATA group.");
            raftService.getMetadataGroupManager().restoreLocalCPMember(this.localCPMember);
            this.metadataStore.persistLocalCPMember(this.localCPMember);
            future.complete(null);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
            this.logger.severe("Could not verify the CP member on the METADATA group", t);
        }
    }

    public void shutdown() {
        this.directoryLock.release();
    }

    public boolean isStartCompleted() {
        return this.startCompleted;
    }

    public File getGroupDir(RaftGroupId groupId) {
        return new File(this.dir, groupId.getName() + "@" + groupId.getSeed() + "@" + groupId.getId());
    }

    private RaftGroupId getGroupId(File groupDir) {
        String[] split = groupDir.getName().split("@");
        if (split.length != 3) {
            throw new IllegalArgumentException("Invalid CP group persistence directory: " + groupDir.getName());
        }
        return new RaftGroupId(split[0], Long.parseLong(split[1]), Long.parseLong(split[2]));
    }

    private File[] getGroupDirs(File dir) {
        return dir.listFiles(path -> path.isDirectory() && new File(path, "members").exists());
    }

    private void runAsync(String taskName, Runnable runnable) {
        String threadName = ThreadUtil.createThreadName(this.node.hazelcastInstance.getName(), taskName);
        new Thread(runnable, threadName).start();
    }

    private class OwnDirComparator
    implements Comparator<File> {
        private OwnDirComparator() {
        }

        @Override
        public int compare(File dir1, File dir2) {
            try {
                CPMemberInfo member1 = new CPMetadataStoreImpl(dir1, CPPersistenceServiceImpl.this.serializationService).readLocalCPMember();
                CPMemberInfo member2 = new CPMetadataStoreImpl(dir2, CPPersistenceServiceImpl.this.serializationService).readLocalCPMember();
                if (member1 == null) {
                    return member2 != null ? 1 : 0;
                }
                if (member2 == null) {
                    return -1;
                }
                Address thisAddress = CPPersistenceServiceImpl.this.node.getThisAddress();
                if (thisAddress.equals(member1.getAddress())) {
                    return -1;
                }
                return thisAddress.equals(member2.getAddress()) ? 1 : 0;
            }
            catch (IOException e) {
                CPPersistenceServiceImpl.this.logger.warning("Could not compare addresses in CP Subsystem persistence directories: " + dir1.getAbsolutePath() + " and " + dir2.getAbsolutePath(), e);
                return 0;
            }
        }
    }

    private class RestoreCPGroupTask
    implements Callable<Void> {
        private final File groupDir;
        private final RaftService raftService;

        RestoreCPGroupTask(File groupDir, RaftService raftService) {
            this.groupDir = groupDir;
            this.raftService = raftService;
        }

        @Override
        public Void call() throws Exception {
            RaftGroupId groupId = CPPersistenceServiceImpl.this.getGroupId(this.groupDir);
            CPPersistenceServiceImpl.this.logger.info("Restoring " + String.valueOf(groupId) + " from " + String.valueOf(this.groupDir));
            int uncommittedEntryCount = CPPersistenceServiceImpl.this.cpSubsystemConfig.getRaftAlgorithmConfig().getUncommittedEntryCountToRejectNewAppends();
            OnDiskRaftStateLoader stateLoader = new OnDiskRaftStateLoader(this.groupDir, uncommittedEntryCount + 1, CPPersistenceServiceImpl.this.node.getSerializationService(), CPPersistenceServiceImpl.this.logger);
            RestoredRaftState restoredState = stateLoader.load();
            if (!CPPersistenceServiceImpl.this.localCPMember.getUuid().equals(restoredState.localEndpoint().getUuid())) {
                throw new IllegalStateException("Local CP member: " + String.valueOf(CPPersistenceServiceImpl.this.localCPMember) + ", restored endpoint: " + String.valueOf(restoredState.localEndpoint()) + ", group: " + String.valueOf(groupId));
            }
            BiTuple<List<CPMember>, Long> restoredCPMemberList = this.restoreCPMemberList(groupId);
            RaftNodeImpl raftNode = this.raftService.restoreRaftNode(groupId, restoredState, stateLoader.logFileStructure());
            if (restoredCPMemberList != null) {
                CPPersistenceServiceImpl.this.runAsync("cp-metadata-restore-thread", () -> this.publishCPMembersUntilMetadataGroupLeaderElected(groupId, raftNode, (Collection)restoredCPMemberList.element1, (Long)restoredCPMemberList.element2));
            }
            CPPersistenceServiceImpl.this.logger.info("Completed restore of " + String.valueOf(groupId));
            return null;
        }

        private BiTuple<List<CPMember>, Long> restoreCPMemberList(RaftGroupId groupId) throws IOException {
            if (!groupId.getName().equals("METADATA")) {
                return null;
            }
            try {
                ArrayList<CPMember> members = new ArrayList<CPMember>();
                long commitIndex = CPPersistenceServiceImpl.this.metadataStore.readActiveCPMembers(members);
                if (members.isEmpty()) {
                    CPPersistenceServiceImpl.this.logger.warning("Restored empty active CP members list with commitIndex: " + commitIndex);
                }
                this.replaceCPMemberIfIPChanged(members);
                return BiTuple.of(members, commitIndex);
            }
            catch (Exception e) {
                CPPersistenceServiceImpl.this.logger.severe(e);
                throw e;
            }
        }

        private void replaceCPMemberIfIPChanged(ArrayList<CPMember> members) {
            CPMemberInfo member = CPPersistenceServiceImpl.this.localCPMember;
            for (int i = 0; i < members.size(); ++i) {
                CPMember m = members.get(i);
                if (!m.getUuid().equals(member.getUuid()) || m.getAddress().equals(member.getAddress())) continue;
                members.set(i, member);
                break;
            }
        }

        private void publishCPMembersUntilMetadataGroupLeaderElected(RaftGroupId metadataGroupId, RaftNodeImpl raftNode, Collection<CPMember> cpMembers, long membersCommitIndex) {
            this.updateInvocationManager(metadataGroupId, membersCommitIndex, cpMembers);
            long timeout = TimeUnit.SECONDS.toMillis(CPPersistenceServiceImpl.this.cpSubsystemConfig.getDataLoadTimeoutSeconds());
            long deadline = Clock.currentTimeMillis() + timeout;
            ClusterServiceImpl clusterService = CPPersistenceServiceImpl.this.node.getClusterService();
            OperationServiceImpl operationService = CPPersistenceServiceImpl.this.node.getNodeEngine().getOperationService();
            PublishRestoredCPMembersOp op = new PublishRestoredCPMembersOp(metadataGroupId, membersCommitIndex, cpMembers);
            while (Clock.currentTimeMillis() < deadline && raftNode.getLeader() == null) {
                if (CPPersistenceServiceImpl.this.logger.isFineEnabled()) {
                    CPPersistenceServiceImpl.this.logger.fine("Broadcasting restored CP members list...");
                }
                for (Member member : clusterService.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR)) {
                    operationService.send(op, member.getAddress());
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (raftNode.getLeader() == null) {
                CPPersistenceServiceImpl.this.logger.severe("Metadata CP group leader election could not not be completed in time during recovery...");
            }
        }

        private void updateInvocationManager(RaftGroupId metadataGroupId, long membersCommitIndex, Collection<CPMember> members) {
            this.raftService.updateInvocationManagerMembers(metadataGroupId.getSeed(), membersCommitIndex, members);
            if (CPPersistenceServiceImpl.this.logger.isFineEnabled()) {
                CPPersistenceServiceImpl.this.logger.fine("Restored seed: " + metadataGroupId.getSeed() + ", members commit index: " + membersCommitIndex + ", CP member list: " + String.valueOf(members));
            }
        }
    }
}

