/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap.operation;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.cpmap.operation.CPMapRaftOp;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public final class CPMapCompareAndSetOp
extends CPMapRaftOp {
    private Data key;
    private Data expectedValue;
    private Data newValue;

    public CPMapCompareAndSetOp() {
    }

    public CPMapCompareAndSetOp(String objectName, Data key, Data expectedValue, Data newValue) {
        super(objectName);
        this.key = key;
        this.expectedValue = expectedValue;
        this.newValue = newValue;
    }

    @Override
    public Object run(CPGroupId groupId, long commitIndex) throws Exception {
        return this.getMap(groupId, this.objectName).compareAndSet(this.key, this.expectedValue, this.newValue);
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        IOUtil.writeData(out, this.key);
        IOUtil.writeData(out, this.expectedValue);
        IOUtil.writeData(out, this.newValue);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.key = IOUtil.readData(in);
        this.expectedValue = IOUtil.readData(in);
        this.newValue = IOUtil.readData(in);
    }
}

