/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap;

import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftNodeLifecycleAwareService;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapProxy;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapRegistry;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapRegistrySnapshot;
import com.hazelcast.cp.internal.datastructures.cpmap.store.CPMapStore;
import com.hazelcast.cp.internal.datastructures.spi.RaftManagedService;
import com.hazelcast.cp.internal.datastructures.spi.RaftRemoteService;
import com.hazelcast.cp.internal.raft.SnapshotAwareService;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class CPMapService
implements RaftManagedService,
RaftRemoteService,
SnapshotAwareService<CPMapRegistrySnapshot>,
RaftNodeLifecycleAwareService,
DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:raft:mapService";
    private final NodeEngine nodeEngine;
    private final Map<CPGroupId, CPMapRegistry> mapRegistries = new ConcurrentHashMap<CPGroupId, CPMapRegistry>();
    private final CPSubsystemConfig cpSubsystemConfig;
    private volatile RaftService raftService;

    public CPMapService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.cpSubsystemConfig = nodeEngine.getConfig().getCPSubsystemConfig();
    }

    public CPMapStore getOrInitMapStore(CPGroupId groupId, String objectName) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(objectName);
        return this.mapRegistries.computeIfAbsent(groupId, r -> new CPMapRegistry(groupId)).getMapStore(objectName, this.cpSubsystemConfig);
    }

    @Override
    public void onCPSubsystemRestart() {
        this.mapRegistries.clear();
    }

    public DistributedObject createProxy(String objectName) {
        RaftGroupId groupId = this.raftService.createRaftGroupForProxy(objectName);
        return new CPMapProxy(this.nodeEngine, groupId, objectName);
    }

    @Override
    public boolean destroyRaftObject(CPGroupId groupId, String objectName) {
        return this.mapRegistries.computeIfAbsent(groupId, r -> new CPMapRegistry(groupId)).destroyMapStore(objectName);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.raftService = (RaftService)nodeEngine.getService("hz:core:raft");
        if (nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES) && nodeEngine instanceof NodeEngineImpl) {
            NodeEngineImpl nodeEngineImpl = (NodeEngineImpl)nodeEngine;
            nodeEngineImpl.getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        this.mapRegistries.clear();
    }

    @Override
    public CPMapRegistrySnapshot takeSnapshot(CPGroupId groupId, long commitIndex) {
        CPMapRegistry cpMapRegistry = this.mapRegistries.get(groupId);
        return cpMapRegistry == null ? new CPMapRegistrySnapshot() : cpMapRegistry.getCPMapRegistrySnapshot();
    }

    @Override
    public void restoreSnapshot(CPGroupId groupId, long commitIndex, CPMapRegistrySnapshot snapshot) {
        if (!snapshot.isEmpty()) {
            CPMapRegistry cpMapRegistry = new CPMapRegistry(groupId);
            cpMapRegistry.restoreCPMapRegistrySnapshot(snapshot);
            this.mapRegistries.put(groupId, cpMapRegistry);
        }
    }

    @Override
    public void onRaftNodeTerminated(CPGroupId groupId) {
        this.mapRegistries.remove(groupId);
    }

    @Override
    public void onRaftNodeSteppedDown(CPGroupId groupId) {
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor root = descriptor.withPrefix("cp.map");
        for (CPMapRegistry cpMapRegistry : this.mapRegistries.values()) {
            cpMapRegistry.collectMetrics(root, context);
        }
    }
}

