/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMap;
import com.hazelcast.cp.internal.RaftInvocationManager;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.cpmap.operation.CPMapCompareAndSetOp;
import com.hazelcast.cp.internal.datastructures.cpmap.operation.CPMapDeleteOp;
import com.hazelcast.cp.internal.datastructures.cpmap.operation.CPMapGetOp;
import com.hazelcast.cp.internal.datastructures.cpmap.operation.CPMapPutIfAbsentOp;
import com.hazelcast.cp.internal.datastructures.cpmap.operation.CPMapPutOp;
import com.hazelcast.cp.internal.datastructures.cpmap.operation.CPMapRemoveOp;
import com.hazelcast.cp.internal.datastructures.cpmap.operation.CPMapSetOp;
import com.hazelcast.cp.internal.datastructures.spi.operation.DestroyRaftObjectOp;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import javax.annotation.Nonnull;

public class CPMapProxy<K, V>
implements CPMap<K, V> {
    public static final String MESSAGE_EXPECTED_VALUE = "argument 'expectedValue' cannot be null";
    public static final String MESSAGE_NEW_VALUE = "argument 'newValue' cannot be null";
    public static final String MESSAGE_KEY = "argument 'key' cannot be null";
    public static final String MESSAGE_VALUE = "argument 'value' cannot be null";
    private final NodeEngine nodeEngine;
    private final CPGroupId groupId;
    private final String objectName;
    private final RaftInvocationManager invocationManager;
    private final String proxyName;
    private final SerializationService serializationService;

    public CPMapProxy(NodeEngine nodeEngine, CPGroupId groupId, String proxyName) {
        this.nodeEngine = nodeEngine;
        this.groupId = groupId;
        this.proxyName = proxyName;
        RaftService raftService = (RaftService)nodeEngine.getService("hz:core:raft");
        this.invocationManager = raftService.getInvocationManager();
        this.serializationService = nodeEngine.getSerializationService();
        this.objectName = RaftService.getObjectNameForProxy(proxyName);
    }

    private <T> T synchronousRaftOp(RaftOp raftOp, boolean isQuery) {
        if (this.nodeEngine.getClusterService().getClusterVersion().isUnknownOrLessThan(Versions.V5_4)) {
            throw new UnsupportedOperationException("CP Map is supported in version 5.4 and above");
        }
        InternalCompletableFuture f = isQuery ? this.invocationManager.query(this.groupId, raftOp, QueryPolicy.LINEARIZABLE) : this.invocationManager.invoke(this.groupId, raftOp);
        Object result = f.joinInternal();
        return this.serializationService.toObject(result);
    }

    private <T> T invoke(RaftOp raftOp) {
        return this.synchronousRaftOp(raftOp, false);
    }

    private <T> T query(RaftOp raftOp) {
        return this.synchronousRaftOp(raftOp, true);
    }

    private Data toData(Object o) {
        return this.serializationService.toData(o);
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        return this.invokeKeyValueRaftOp(key, value, new CPMapPutOp(this.objectName, this.toData(key), this.toData(value)));
    }

    @Override
    public V putIfAbsent(@Nonnull K key, @Nonnull V value) {
        return this.invokeKeyValueRaftOp(key, value, new CPMapPutIfAbsentOp(this.objectName, this.toData(key), this.toData(value)));
    }

    @Override
    public void set(@Nonnull K key, @Nonnull V value) {
        this.invokeKeyValueRaftOp(key, value, new CPMapSetOp(this.objectName, this.toData(key), this.toData(value)));
    }

    private V invokeKeyValueRaftOp(K key, V value, RaftOp raftOp) {
        Preconditions.checkNotNull(key, MESSAGE_KEY);
        Preconditions.checkNotNull(value, MESSAGE_VALUE);
        return (V)this.invoke(raftOp);
    }

    @Override
    public V remove(@Nonnull K key) {
        Preconditions.checkNotNull(key, MESSAGE_KEY);
        return (V)this.invoke(new CPMapRemoveOp(this.objectName, this.toData(key)));
    }

    @Override
    public void delete(@Nonnull K key) {
        Preconditions.checkNotNull(key, MESSAGE_KEY);
        this.invoke(new CPMapDeleteOp(this.objectName, this.toData(key)));
    }

    @Override
    public boolean compareAndSet(@Nonnull K key, @Nonnull V expectedValue, @Nonnull V newValue) {
        Preconditions.checkNotNull(key, MESSAGE_KEY);
        Preconditions.checkNotNull(expectedValue, MESSAGE_EXPECTED_VALUE);
        Preconditions.checkNotNull(newValue, MESSAGE_NEW_VALUE);
        return (Boolean)this.invoke(new CPMapCompareAndSetOp(this.objectName, this.toData(key), this.toData(expectedValue), this.toData(newValue)));
    }

    @Override
    public V get(@Nonnull K key) {
        Preconditions.checkNotNull(key, MESSAGE_KEY);
        return (V)this.query(new CPMapGetOp(this.objectName, this.toData(key)));
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.proxyName;
    }

    @Override
    public String getServiceName() {
        return "hz:raft:mapService";
    }

    @Override
    public void destroy() {
        this.invocationManager.invoke(this.groupId, new DestroyRaftObjectOp(this.getServiceName(), this.objectName)).joinInternal();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }
}

