/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.tpc.TpcSocketConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.spi.annotation.Beta;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class RestServerEndpointConfig
extends ServerSocketEndpointConfig {
    private final Set<Integer> enabledGroupCodes = Collections.synchronizedSet(new HashSet());

    public RestServerEndpointConfig() {
        for (RestEndpointGroup eg : RestEndpointGroup.getAllEndpointGroups()) {
            if (!eg.isEnabledByDefault()) continue;
            this.enabledGroupCodes.add(eg.getCode());
        }
    }

    @Override
    public final ProtocolType getProtocolType() {
        return ProtocolType.REST;
    }

    @Override
    public EndpointQualifier getQualifier() {
        return EndpointQualifier.REST;
    }

    public RestServerEndpointConfig enableAllGroups() {
        return this.enableGroups(RestEndpointGroup.values());
    }

    public RestServerEndpointConfig enableGroups(RestEndpointGroup ... endpointGroups) {
        if (endpointGroups != null) {
            this.enabledGroupCodes.addAll(Arrays.stream(endpointGroups).map(RestEndpointGroup::getCode).collect(Collectors.toSet()));
        }
        return this;
    }

    public RestServerEndpointConfig disableAllGroups() {
        this.enabledGroupCodes.clear();
        return this;
    }

    public RestServerEndpointConfig disableGroups(RestEndpointGroup ... endpointGroups) {
        if (endpointGroups != null) {
            Arrays.stream(endpointGroups).map(RestEndpointGroup::getCode).forEach(this.enabledGroupCodes::remove);
        }
        return this;
    }

    public boolean isEnabledAndNotEmpty() {
        return !this.enabledGroupCodes.isEmpty();
    }

    public Set<RestEndpointGroup> getEnabledGroups() {
        return this.enabledGroupCodes.stream().map(RestEndpointGroup::getRestEndpointGroup).collect(Collectors.toSet());
    }

    public boolean isGroupEnabled(RestEndpointGroup group) {
        return this.enabledGroupCodes.contains(group.getCode());
    }

    public RestServerEndpointConfig setEnabledGroups(Collection<RestEndpointGroup> groups) {
        this.enabledGroupCodes.clear();
        if (groups != null) {
            this.enabledGroupCodes.addAll(groups.stream().map(RestEndpointGroup::getCode).collect(Collectors.toSet()));
        }
        return this;
    }

    @Override
    public RestServerEndpointConfig setPublicAddress(String publicAddress) {
        super.setPublicAddress(publicAddress);
        return this;
    }

    @Override
    public RestServerEndpointConfig setPort(int port) {
        super.setPort(port);
        return this;
    }

    @Override
    public RestServerEndpointConfig setPortAutoIncrement(boolean portAutoIncrement) {
        super.setPortAutoIncrement(portAutoIncrement);
        return this;
    }

    @Override
    public RestServerEndpointConfig setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public RestServerEndpointConfig setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public RestServerEndpointConfig setOutboundPortDefinitions(Collection<String> outboundPortDefs) {
        super.setOutboundPortDefinitions((Collection)outboundPortDefs);
        return this;
    }

    @Override
    public RestServerEndpointConfig setOutboundPorts(Collection<Integer> outboundPorts) {
        super.setOutboundPorts((Collection)outboundPorts);
        return this;
    }

    @Override
    public RestServerEndpointConfig setInterfaces(InterfacesConfig interfaces) {
        super.setInterfaces(interfaces);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketBufferDirect(boolean socketBufferDirect) {
        super.setSocketBufferDirect(socketBufferDirect);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketKeepAlive(boolean socketKeepAlive) {
        super.setSocketKeepAlive(socketKeepAlive);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketTcpNoDelay(boolean socketTcpNoDelay) {
        super.setSocketTcpNoDelay(socketTcpNoDelay);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketSendBufferSizeKb(int socketSendBufferSizeKb) {
        super.setSocketSendBufferSizeKb(socketSendBufferSizeKb);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketRcvBufferSizeKb(int socketRcvBufferSizeKb) {
        super.setSocketRcvBufferSizeKb(socketRcvBufferSizeKb);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketLingerSeconds(int socketLingerSeconds) {
        super.setSocketLingerSeconds(socketLingerSeconds);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketConnectTimeoutSeconds(int socketConnectTimeoutSeconds) {
        super.setSocketConnectTimeoutSeconds(socketConnectTimeoutSeconds);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        super.setSocketInterceptorConfig(socketInterceptorConfig);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSSLConfig(SSLConfig sslConfig) {
        super.setSSLConfig(sslConfig);
        return this;
    }

    @Override
    @Beta
    @Nonnull
    public RestServerEndpointConfig setTpcSocketConfig(@Nonnull TpcSocketConfig tpcSocketConfig) {
        super.setTpcSocketConfig(tpcSocketConfig);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSymmetricEncryptionConfig(SymmetricEncryptionConfig symmetricEncryptionConfig) {
        super.setSymmetricEncryptionConfig(symmetricEncryptionConfig);
        return this;
    }

    @Override
    public RestServerEndpointConfig addOutboundPortDefinition(String portDef) {
        super.addOutboundPortDefinition(portDef);
        return this;
    }

    @Override
    public RestServerEndpointConfig addOutboundPort(int port) {
        super.addOutboundPort(port);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketKeepIdleSeconds(int socketKeepIdleSeconds) {
        super.setSocketKeepIdleSeconds(socketKeepIdleSeconds);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketKeepIntervalSeconds(int socketKeepIntervalSeconds) {
        super.setSocketKeepIntervalSeconds(socketKeepIntervalSeconds);
        return this;
    }

    @Override
    public RestServerEndpointConfig setSocketKeepCount(int socketKeepCount) {
        super.setSocketKeepCount(socketKeepCount);
        return this;
    }

    @Override
    public String toString() {
        return "RestServerEndpointConfig{enabledGroups=" + String.valueOf(this.getEnabledGroups()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RestServerEndpointConfig that = (RestServerEndpointConfig)o;
        return Objects.equals(this.enabledGroupCodes, that.enabledGroupCodes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.enabledGroupCodes);
    }
}

