/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.collection.QueueStore;
import com.hazelcast.collection.QueueStoreFactory;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QueueStoreConfig
implements IdentifiedDataSerializable {
    public static final int DEFAULT_MEMORY_LIMIT = 1000;
    public static final int DEFAULT_BULK_LOAD = 250;
    public static final String STORE_BINARY = "binary";
    public static final String STORE_MEMORY_LIMIT = "memory-limit";
    public static final String STORE_BULK_LOAD = "bulk-load";
    private boolean enabled = true;
    private String className;
    private String factoryClassName;
    private Properties properties = new Properties();
    private QueueStore storeImplementation;
    private QueueStoreFactory factoryImplementation;

    public QueueStoreConfig() {
    }

    public QueueStoreConfig(QueueStoreConfig config) {
        this.enabled = config.isEnabled();
        this.className = config.getClassName();
        this.storeImplementation = config.getStoreImplementation();
        this.factoryClassName = config.getFactoryClassName();
        this.factoryImplementation = config.getFactoryImplementation();
        this.properties.putAll((Map<?, ?>)config.getProperties());
    }

    @Nullable
    public QueueStore getStoreImplementation() {
        return this.storeImplementation;
    }

    public QueueStoreConfig setStoreImplementation(@Nonnull QueueStore storeImplementation) {
        this.storeImplementation = Preconditions.checkNotNull(storeImplementation, "Queue store cannot be null!");
        this.className = null;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public QueueStoreConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    public String getClassName() {
        return this.className;
    }

    public QueueStoreConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Queue store class name must contain text");
        this.storeImplementation = null;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public QueueStoreConfig setProperties(Properties properties) {
        this.properties = Preconditions.checkNotNull(properties, "Queue store config properties cannot be null");
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public QueueStoreConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    @Nullable
    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public QueueStoreConfig setFactoryClassName(@Nonnull String factoryClassName) {
        this.factoryClassName = Preconditions.checkHasText(factoryClassName, "Queue factory store class name must contain text");
        this.factoryImplementation = null;
        return this;
    }

    @Nullable
    public QueueStoreFactory getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public QueueStoreConfig setFactoryImplementation(@Nonnull QueueStoreFactory factoryImplementation) {
        this.factoryImplementation = Preconditions.checkNotNull(factoryImplementation, "Queue store factory cannot be null!");
        this.factoryClassName = null;
        return this;
    }

    public String toString() {
        return "QueueStoreConfig{enabled=" + this.enabled + ", className='" + this.className + "', storeImplementation=" + String.valueOf(this.storeImplementation) + ", factoryClassName='" + this.factoryClassName + "', factoryImplementation=" + String.valueOf(this.factoryImplementation) + ", properties=" + String.valueOf(this.properties) + "}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 26;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeString(this.className);
        out.writeString(this.factoryClassName);
        out.writeObject(this.properties);
        out.writeObject(this.storeImplementation);
        out.writeObject(this.factoryImplementation);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.className = in.readString();
        this.factoryClassName = in.readString();
        this.properties = (Properties)in.readObject();
        this.storeImplementation = (QueueStore)in.readObject();
        this.factoryImplementation = (QueueStoreFactory)in.readObject();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueueStoreConfig)) {
            return false;
        }
        QueueStoreConfig that = (QueueStoreConfig)o;
        return this.isEnabled() == that.isEnabled() && Objects.equals(this.getProperties(), that.getProperties()) && Objects.equals(this.className, that.className) && Objects.equals(this.storeImplementation, that.storeImplementation) && Objects.equals(this.factoryClassName, that.factoryClassName) && Objects.equals(this.factoryImplementation, that.factoryImplementation);
    }

    public final int hashCode() {
        return Objects.hash(this.isEnabled(), this.className, this.storeImplementation, this.getProperties(), this.factoryClassName, this.factoryImplementation);
    }
}

