/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class QueryCacheConfig
implements IdentifiedDataSerializable {
    public static final int DEFAULT_BATCH_SIZE = 1;
    public static final int DEFAULT_BUFFER_SIZE = 16;
    public static final int DEFAULT_DELAY_SECONDS = 0;
    public static final boolean DEFAULT_INCLUDE_VALUE = true;
    public static final boolean DEFAULT_POPULATE = true;
    public static final boolean DEFAULT_COALESCE = false;
    public static final boolean DEFAULT_SERIALIZE_KEYS = false;
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private int batchSize = 1;
    private int bufferSize = 16;
    private int delaySeconds = 0;
    private boolean includeValue = true;
    private boolean populate = true;
    private boolean coalesce = false;
    private boolean serializeKeys = false;
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private String name;
    private PredicateConfig predicateConfig = new PredicateConfig();
    private EvictionConfig evictionConfig = new EvictionConfig();
    private List<EntryListenerConfig> entryListenerConfigs;
    private List<IndexConfig> indexConfigs;

    public QueryCacheConfig() {
    }

    public QueryCacheConfig(String name) {
        this.setName(name);
    }

    public QueryCacheConfig(QueryCacheConfig other) {
        this.batchSize = other.batchSize;
        this.bufferSize = other.bufferSize;
        this.delaySeconds = other.delaySeconds;
        this.includeValue = other.includeValue;
        this.populate = other.populate;
        this.coalesce = other.coalesce;
        this.inMemoryFormat = other.inMemoryFormat;
        this.name = other.name;
        this.predicateConfig = other.predicateConfig;
        this.evictionConfig = other.evictionConfig;
        this.entryListenerConfigs = other.entryListenerConfigs;
        this.indexConfigs = other.indexConfigs;
    }

    public String getName() {
        return this.name;
    }

    public QueryCacheConfig setName(String name) {
        Preconditions.checkHasText(name, "name");
        this.name = name;
        return this;
    }

    public PredicateConfig getPredicateConfig() {
        return this.predicateConfig;
    }

    public QueryCacheConfig setPredicateConfig(PredicateConfig predicateConfig) {
        this.predicateConfig = Preconditions.checkNotNull(predicateConfig, "predicateConfig can not be null");
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public QueryCacheConfig setBatchSize(int batchSize) {
        this.batchSize = Preconditions.checkPositive("batchSize", batchSize);
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public QueryCacheConfig setBufferSize(int bufferSize) {
        this.bufferSize = Preconditions.checkPositive("bufferSize", bufferSize);
        return this;
    }

    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    public QueryCacheConfig setDelaySeconds(int delaySeconds) {
        this.delaySeconds = Preconditions.checkNotNegative(delaySeconds, "delaySeconds");
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public QueryCacheConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        Preconditions.checkNotNull(inMemoryFormat, "inMemoryFormat cannot be null");
        Preconditions.checkFalse(inMemoryFormat == InMemoryFormat.NATIVE, "InMemoryFormat." + String.valueOf((Object)inMemoryFormat) + " is not supported.");
        this.inMemoryFormat = inMemoryFormat;
        return this;
    }

    public boolean isIncludeValue() {
        return this.includeValue;
    }

    public QueryCacheConfig setIncludeValue(boolean includeValue) {
        this.includeValue = includeValue;
        return this;
    }

    public boolean isPopulate() {
        return this.populate;
    }

    public QueryCacheConfig setPopulate(boolean populate) {
        this.populate = populate;
        return this;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public QueryCacheConfig setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
        return this;
    }

    public boolean isSerializeKeys() {
        return this.serializeKeys;
    }

    public QueryCacheConfig setSerializeKeys(boolean serializeKeys) {
        this.serializeKeys = serializeKeys;
        return this;
    }

    public EvictionConfig getEvictionConfig() {
        return this.evictionConfig;
    }

    public QueryCacheConfig setEvictionConfig(EvictionConfig evictionConfig) {
        Preconditions.checkNotNull(evictionConfig, "evictionConfig cannot be null");
        this.evictionConfig = evictionConfig;
        return this;
    }

    public QueryCacheConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        Preconditions.checkNotNull(listenerConfig, "listenerConfig cannot be null");
        this.getEntryListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<EntryListenerConfig> getEntryListenerConfigs() {
        if (this.entryListenerConfigs == null) {
            this.entryListenerConfigs = new ArrayList<EntryListenerConfig>();
        }
        return this.entryListenerConfigs;
    }

    public QueryCacheConfig setEntryListenerConfigs(List<EntryListenerConfig> listenerConfigs) {
        Preconditions.checkNotNull(listenerConfigs, "listenerConfig cannot be null");
        this.entryListenerConfigs = listenerConfigs;
        return this;
    }

    public QueryCacheConfig addIndexConfig(IndexConfig indexConfig) {
        this.getIndexConfigs().add(indexConfig);
        return this;
    }

    public List<IndexConfig> getIndexConfigs() {
        if (this.indexConfigs == null) {
            this.indexConfigs = new ArrayList<IndexConfig>();
        }
        return this.indexConfigs;
    }

    public QueryCacheConfig setIndexConfigs(List<IndexConfig> indexConfigs) {
        this.indexConfigs = indexConfigs;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 19;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.batchSize);
        out.writeInt(this.bufferSize);
        out.writeInt(this.delaySeconds);
        out.writeBoolean(this.includeValue);
        out.writeBoolean(this.populate);
        out.writeBoolean(this.coalesce);
        out.writeString(this.inMemoryFormat.name());
        out.writeString(this.name);
        out.writeObject(this.predicateConfig);
        out.writeObject(this.evictionConfig);
        SerializationUtil.writeNullableList(this.entryListenerConfigs, out);
        SerializationUtil.writeNullableList(this.indexConfigs, out);
        out.writeBoolean(this.serializeKeys);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.batchSize = in.readInt();
        this.bufferSize = in.readInt();
        this.delaySeconds = in.readInt();
        this.includeValue = in.readBoolean();
        this.populate = in.readBoolean();
        this.coalesce = in.readBoolean();
        this.inMemoryFormat = InMemoryFormat.valueOf(in.readString());
        this.name = in.readString();
        this.predicateConfig = (PredicateConfig)in.readObject();
        this.evictionConfig = (EvictionConfig)in.readObject();
        this.entryListenerConfigs = SerializationUtil.readNullableList(in);
        this.indexConfigs = SerializationUtil.readNullableList(in);
        this.serializeKeys = in.readBoolean();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryCacheConfig)) {
            return false;
        }
        QueryCacheConfig that = (QueryCacheConfig)o;
        if (this.batchSize != that.batchSize) {
            return false;
        }
        if (this.bufferSize != that.bufferSize) {
            return false;
        }
        if (this.delaySeconds != that.delaySeconds) {
            return false;
        }
        if (this.includeValue != that.includeValue) {
            return false;
        }
        if (this.populate != that.populate) {
            return false;
        }
        if (this.coalesce != that.coalesce) {
            return false;
        }
        if (this.serializeKeys != that.serializeKeys) {
            return false;
        }
        if (this.inMemoryFormat != that.inMemoryFormat) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.predicateConfig, that.predicateConfig)) {
            return false;
        }
        if (!Objects.equals(this.evictionConfig, that.evictionConfig)) {
            return false;
        }
        if (!Objects.equals(this.entryListenerConfigs, that.entryListenerConfigs)) {
            return false;
        }
        return Objects.equals(this.indexConfigs, that.indexConfigs);
    }

    public final int hashCode() {
        int result = this.batchSize;
        result = 31 * result + this.bufferSize;
        result = 31 * result + this.delaySeconds;
        result = 31 * result + (this.includeValue ? 1 : 0);
        result = 31 * result + (this.populate ? 1 : 0);
        result = 31 * result + (this.coalesce ? 1 : 0);
        result = 31 * result + (this.serializeKeys ? 1 : 0);
        result = 31 * result + (this.inMemoryFormat != null ? this.inMemoryFormat.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.predicateConfig != null ? this.predicateConfig.hashCode() : 0);
        result = 31 * result + (this.evictionConfig != null ? this.evictionConfig.hashCode() : 0);
        result = 31 * result + (this.entryListenerConfigs != null ? this.entryListenerConfigs.hashCode() : 0);
        result = 31 * result + (this.indexConfigs != null ? this.indexConfigs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "QueryCacheConfig{batchSize=" + this.batchSize + ", bufferSize=" + this.bufferSize + ", delaySeconds=" + this.delaySeconds + ", includeValue=" + this.includeValue + ", populate=" + this.populate + ", coalesce=" + this.coalesce + ", serializeKeys=" + this.serializeKeys + ", inMemoryFormat=" + String.valueOf((Object)this.inMemoryFormat) + ", name='" + this.name + "', predicateConfig=" + String.valueOf(this.predicateConfig) + ", evictionConfig=" + String.valueOf(this.evictionConfig) + ", entryListenerConfigs=" + String.valueOf(this.entryListenerConfigs) + ", indexConfigs=" + String.valueOf(this.indexConfigs) + "}";
    }
}

