/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi;

import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDestroyProxyCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import java.util.UUID;
import javax.annotation.Nonnull;

public abstract class ClientProxy
implements DistributedObject {
    protected final String name;
    private final String serviceName;
    private final ClientContext context;
    private final SerializationService serializationService;

    protected ClientProxy(String serviceName, String name, ClientContext context) {
        this.serviceName = serviceName;
        this.name = name;
        this.context = context;
        this.serializationService = context.getSerializationService();
    }

    @Nonnull
    protected final UUID registerListener(ListenerMessageCodec codec, EventHandler handler) {
        return this.getContext().getListenerService().registerListener(codec, handler);
    }

    protected final boolean deregisterListener(@Nonnull UUID registrationId) {
        return this.getContext().getListenerService().deregisterListener(registrationId);
    }

    public final ClientContext getContext() {
        return this.context;
    }

    protected SerializationService getSerializationService() {
        return this.serializationService;
    }

    protected <T> Data toData(T o) {
        return this.getSerializationService().toData(o);
    }

    protected <T> T toObject(Object data) {
        return this.getSerializationService().toObject(data);
    }

    protected final HazelcastClientInstanceImpl getClient() {
        return (HazelcastClientInstanceImpl)this.getContext().getHazelcastInstance();
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Override
    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey(this.getDistributedObjectName());
    }

    @Override
    public final String getServiceName() {
        return this.serviceName;
    }

    protected String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public final void destroy() {
        this.getContext().getProxyManager().destroyProxy(this);
    }

    public final void destroyLocally() {
        if (this.preDestroy()) {
            try {
                this.onDestroy();
            }
            finally {
                this.postDestroy();
            }
        }
    }

    public final void destroyRemotely() {
        ClientMessage clientMessage = ClientDestroyProxyCodec.encodeRequest(this.getDistributedObjectName(), this.getServiceName());
        try {
            new ClientInvocation(this.getClient(), clientMessage, this.getName()).invoke().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected void onInitialize() {
    }

    protected void onDestroy() {
    }

    protected boolean preDestroy() {
        return true;
    }

    protected void postDestroy() {
    }

    protected void onShutdown() {
    }

    protected <T> T invoke(ClientMessage clientMessage, Object key) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(key);
        return this.invokeOnPartition(clientMessage, partitionId);
    }

    protected <T> T invokeOnPartition(ClientMessage clientMessage, int partitionId) {
        try {
            ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstance)this.getClient(), clientMessage, (Object)this.getName(), partitionId).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected <T> T invokeOnMember(ClientMessage clientMessage, UUID uuid) {
        try {
            ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstance)this.getClient(), clientMessage, (Object)this.getName(), uuid).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected <T> T invokeOnPartitionInterruptibly(ClientMessage clientMessage, int partitionId) throws InterruptedException {
        try {
            ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstance)this.getClient(), clientMessage, (Object)this.getName(), partitionId).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrowAllowInterrupted(e);
        }
    }

    protected <T> T invoke(ClientMessage clientMessage) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, this.getName()).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProxy that = (ClientProxy)o;
        if (!this.getInstanceName().equals(that.getInstanceName())) {
            return false;
        }
        if (!this.getDistributedObjectName().equals(that.getDistributedObjectName())) {
            return false;
        }
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        int result = this.getInstanceName().hashCode();
        result = 31 * result + this.serviceName.hashCode();
        result = 31 * result + this.getDistributedObjectName().hashCode();
        return result;
    }

    private String getInstanceName() {
        ClientContext context = this.getContext();
        return context != null ? context.getHazelcastInstance().getName() : "";
    }
}

