/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy.txn.xa;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.XATransactionClearRemoteCodec;
import com.hazelcast.client.impl.protocol.codec.XATransactionCollectTransactionsCodec;
import com.hazelcast.client.impl.protocol.codec.XATransactionFinalizeCodec;
import com.hazelcast.client.impl.proxy.txn.xa.XATransactionContextProxy;
import com.hazelcast.client.impl.proxy.txn.xa.XATransactionProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.ClientTransactionManagerService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.ILogger;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.XAResourceImpl;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceProxy
extends ClientProxy
implements HazelcastXAResource {
    private static final int DEFAULT_TIMEOUT_SECONDS = (int)TimeUnit.MILLISECONDS.toSeconds(TransactionOptions.DEFAULT_TIMEOUT_MILLIS);
    private final ConcurrentMap<Long, TransactionContext> threadContextMap = new ConcurrentHashMap<Long, TransactionContext>();
    private final ConcurrentMap<Xid, List<TransactionContext>> xidContextMap = new ConcurrentHashMap<Xid, List<TransactionContext>>();
    private final AtomicInteger timeoutInSeconds = new AtomicInteger(DEFAULT_TIMEOUT_SECONDS);

    public XAResourceProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        long threadId = this.currentThreadId();
        TransactionContext threadContext = (TransactionContext)this.threadContextMap.get(this.currentThreadId());
        switch (flags) {
            case 0: {
                CopyOnWriteArrayList<TransactionContext> contexts = new CopyOnWriteArrayList<TransactionContext>();
                List currentContexts = this.xidContextMap.putIfAbsent(xid, contexts);
                if (currentContexts != null) {
                    throw new XAException("There is already TransactionContexts for the given xid: " + String.valueOf(xid));
                }
                TransactionContext context = this.createTransactionContext(xid);
                contexts.add(context);
                this.threadContextMap.put(threadId, context);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                List contextList = (List)this.xidContextMap.get(xid);
                if (contextList == null) {
                    throw new XAException("There is no TransactionContexts for the given xid: " + String.valueOf(xid));
                }
                if (threadContext != null) break;
                threadContext = this.createTransactionContext(xid);
                this.threadContextMap.put(threadId, threadContext);
                contextList.add(threadContext);
                break;
            }
            default: {
                throw new XAException("Unknown flag!" + flags);
            }
        }
    }

    private TransactionContext createTransactionContext(Xid xid) {
        ClientTransactionManagerService transactionManager = this.getContext().getTransactionManager();
        TransactionContext context = transactionManager.newXATransactionContext(xid, this.timeoutInSeconds.get());
        this.getTransaction(context).begin();
        return context;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        List contexts;
        long threadId = this.currentThreadId();
        TransactionContext threadContext = (TransactionContext)this.threadContextMap.remove(threadId);
        ILogger logger = this.getContext().getLoggingService().getLogger(this.getClass());
        if (threadContext == null && logger.isFinestEnabled()) {
            logger.finest("There is no TransactionContext for the current thread: " + threadId);
        }
        if ((contexts = (List)this.xidContextMap.get(xid)) == null && logger.isFinestEnabled()) {
            logger.finest("There is no TransactionContexts for the given xid: " + String.valueOf(xid));
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        List contexts = (List)this.xidContextMap.get(xid);
        if (contexts == null) {
            throw new XAException("There is no TransactionContexts for the given xid: " + String.valueOf(xid));
        }
        for (TransactionContext context : contexts) {
            XATransactionProxy transaction = this.getTransaction(context);
            transaction.prepare();
        }
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        List contexts = (List)this.xidContextMap.remove(xid);
        if (contexts == null && onePhase) {
            throw new XAException("There is no TransactionContexts for the given xid: " + String.valueOf(xid));
        }
        if (contexts == null) {
            this.finalizeTransactionRemotely(xid, true);
            return;
        }
        for (TransactionContext context : contexts) {
            XATransactionProxy transaction = this.getTransaction(context);
            transaction.commit(onePhase);
        }
        this.clearRemoteTransactions(xid);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        List contexts = (List)this.xidContextMap.remove(xid);
        if (contexts == null) {
            this.finalizeTransactionRemotely(xid, false);
            return;
        }
        for (TransactionContext context : contexts) {
            this.getTransaction(context).rollback();
        }
        this.clearRemoteTransactions(xid);
    }

    private void finalizeTransactionRemotely(Xid xid, boolean isCommit) {
        SerializableXID serializableXID = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        Data xidData = this.toData(serializableXID);
        ClientMessage request = XATransactionFinalizeCodec.encodeRequest(serializableXID, isCommit);
        this.invoke(request, xidData);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        List contexts = (List)this.xidContextMap.remove(xid);
        if (contexts == null) {
            throw new XAException("No context with the given xid: " + String.valueOf(xid));
        }
        this.clearRemoteTransactions(xid);
    }

    private void clearRemoteTransactions(Xid xid) {
        SerializableXID serializableXID = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        Data xidData = this.toData(serializableXID);
        ClientMessage request = XATransactionClearRemoteCodec.encodeRequest(serializableXID);
        this.invoke(request, xidData);
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (this == xaResource) {
            return true;
        }
        String otherClusterName = null;
        if (xaResource instanceof XAResourceProxy) {
            otherClusterName = ((XAResourceProxy)xaResource).getClusterName();
        }
        if (xaResource instanceof XAResourceImpl) {
            otherClusterName = ((XAResourceImpl)xaResource).getClusterName();
        }
        return this.getClusterName().equals(otherClusterName);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        ClientMessage request = XATransactionCollectTransactionsCodec.encodeRequest();
        ClientMessage response = (ClientMessage)this.invoke(request);
        List<Xid> list = XATransactionCollectTransactionsCodec.decodeResponse(response);
        return list.toArray(new Xid[0]);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeoutInSeconds.get();
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.timeoutInSeconds.set(seconds == 0 ? DEFAULT_TIMEOUT_SECONDS : seconds);
        return true;
    }

    @Override
    @Nonnull
    public TransactionContext getTransactionContext() {
        long threadId = Thread.currentThread().getId();
        TransactionContext transactionContext = (TransactionContext)this.threadContextMap.get(threadId);
        if (transactionContext == null) {
            throw new IllegalStateException("No TransactionContext associated with current thread: " + threadId);
        }
        return transactionContext;
    }

    private XATransactionProxy getTransaction(TransactionContext context) {
        return ((XATransactionContextProxy)context).getTransaction();
    }

    private long currentThreadId() {
        return Thread.currentThread().getId();
    }

    private String getClusterName() {
        ClientTransactionManagerService transactionManager = this.getContext().getTransactionManager();
        return transactionManager.getClusterName();
    }

    public String toString() {
        return "HazelcastXaResource{" + this.getClusterName() + "}";
    }
}

