/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorDisposeResultCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorIsShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorRetrieveAndDisposeResultCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorRetrieveResultCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorSubmitToPartitionCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.durableexecutor.DurableExecutorServiceFuture;
import com.hazelcast.executor.impl.RunnableAdapter;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.partition.PartitionAware;
import com.hazelcast.spi.impl.DeserializingCompletableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ClientDurableExecutorServiceProxy
extends ClientProxy
implements DurableExecutorService {
    private final Random random = new Random();
    private int partitionCount;

    public ClientDurableExecutorServiceProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    protected void onInitialize() {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        this.partitionCount = partitionService.getPartitionCount();
    }

    @Override
    public <T> Future<T> retrieveResult(long taskId) {
        int partitionId = Bits.extractInt(taskId, false);
        int sequence = Bits.extractInt(taskId, true);
        ClientMessage clientMessage = DurableExecutorRetrieveResultCodec.encodeRequest(this.name, sequence);
        ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstance)this.getClient(), clientMessage, (Object)this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), DurableExecutorRetrieveResultCodec::decodeResponse);
    }

    @Override
    public void disposeResult(long taskId) {
        int partitionId = Bits.extractInt(taskId, false);
        int sequence = Bits.extractInt(taskId, true);
        ClientMessage clientMessage = DurableExecutorDisposeResultCodec.encodeRequest(this.name, sequence);
        this.invokeOnPartition(clientMessage, partitionId);
    }

    @Override
    public <T> Future<T> retrieveAndDisposeResult(long taskId) {
        int partitionId = Bits.extractInt(taskId, false);
        int sequence = Bits.extractInt(taskId, true);
        ClientMessage clientMessage = DurableExecutorRetrieveAndDisposeResultCodec.encodeRequest(this.name, sequence);
        ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstance)this.getClient(), clientMessage, (Object)this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), DurableExecutorRetrieveResultCodec::decodeResponse);
    }

    @Override
    public void execute(@Nonnull Runnable task) {
        int partitionId = this.getTaskPartitionId(task);
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToPartition(callable, partitionId, null);
    }

    @Override
    public void executeOnKeyOwner(@Nonnull Runnable task, @Nonnull Object key) {
        Preconditions.checkNotNull(key, "key must not be null");
        int partitionId = this.getPartitionId(key);
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToPartition(callable, partitionId, null);
    }

    @Override
    public <T> DurableExecutorServiceFuture<T> submitToKeyOwner(@Nonnull Callable<T> task, @Nonnull Object key) {
        Preconditions.checkNotNull(key, "key must not be null");
        int partitionId = this.getPartitionId(key);
        return this.submitToPartition(task, partitionId, null);
    }

    @Override
    public DurableExecutorServiceFuture<?> submitToKeyOwner(@Nonnull Runnable task, @Nonnull Object key) {
        Preconditions.checkNotNull(key, "key must not be null");
        int partitionId = this.getPartitionId(key);
        RunnableAdapter callable = this.createRunnableAdapter(task);
        return this.submitToPartition(callable, partitionId, null);
    }

    @Override
    @Nonnull
    public <T> DurableExecutorServiceFuture<T> submit(@Nonnull Callable<T> task) {
        int partitionId = this.getTaskPartitionId(task);
        return this.submitToPartition(task, partitionId, null);
    }

    @Override
    @Nonnull
    public <T> DurableExecutorServiceFuture<T> submit(@Nonnull Runnable task, T result) {
        int partitionId = this.getTaskPartitionId(task);
        RunnableAdapter<T> callable = this.createRunnableAdapter(task);
        return this.submitToPartition(callable, partitionId, result);
    }

    @Override
    @Nonnull
    public DurableExecutorServiceFuture<?> submit(@Nonnull Runnable task) {
        int partitionId = this.getTaskPartitionId(task);
        RunnableAdapter callable = this.createRunnableAdapter(task);
        return this.submitToPartition(callable, partitionId, null);
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(unit, "unit must not be null");
        return false;
    }

    @Override
    public void shutdown() {
        ClientMessage request = DurableExecutorShutdownCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        ClientMessage request = DurableExecutorIsShutdownCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return DurableExecutorIsShutdownCodec.decodeResponse(response);
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    private <T> DurableExecutorServiceFuture<T> submitToPartition(@Nonnull Callable<T> task, int partitionId, @Nullable T result) {
        int sequence;
        Preconditions.checkNotNull(task, "task should not be null");
        ClientMessage request = DurableExecutorSubmitToPartitionCodec.encodeRequest(this.name, this.toData(task));
        try {
            ClientMessage response = (ClientMessage)this.invokeOnPartition(request, partitionId);
            sequence = DurableExecutorSubmitToPartitionCodec.decodeResponse(response);
        }
        catch (Throwable t) {
            return ClientDurableExecutorServiceProxy.completedExceptionally(t, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
        ClientMessage clientMessage = DurableExecutorRetrieveResultCodec.encodeRequest(this.name, sequence);
        ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstance)this.getClient(), clientMessage, (Object)this.getName(), partitionId).invoke();
        long taskId = Bits.combineToLong(partitionId, sequence);
        return new ClientDurableExecutorServiceDelegatingFuture<T>(future, this.getSerializationService(), DurableExecutorRetrieveResultCodec::decodeResponse, result, taskId);
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(Runnable command) {
        Preconditions.checkNotNull(command, "Command can't be null");
        return new RunnableAdapter(command);
    }

    private int getTaskPartitionId(Object task) {
        Object partitionKey;
        if (task instanceof PartitionAware && (partitionKey = ((PartitionAware)task).getPartitionKey()) != null) {
            return this.getPartitionId(partitionKey);
        }
        return this.random.nextInt(this.partitionCount);
    }

    private int getPartitionId(@Nonnull Object key) {
        return this.getContext().getPartitionService().getPartitionId(key);
    }

    private static <T> DurableExecutorServiceFuture<T> completedExceptionally(Throwable t, Executor executor) {
        return new ClientDurableExecutorServiceCompletedFuture(t, executor);
    }

    private static class ClientDurableExecutorServiceDelegatingFuture<T>
    extends ClientDelegatingFuture<T>
    implements DurableExecutorServiceFuture<T> {
        private final long taskId;

        ClientDurableExecutorServiceDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, T defaultValue, long taskId) {
            super(clientInvocationFuture, serializationService, clientMessageDecoder, defaultValue);
            this.taskId = taskId;
        }

        @Override
        public long getTaskId() {
            return this.taskId;
        }
    }

    private static final class ClientDurableExecutorServiceCompletedFuture<T>
    extends DeserializingCompletableFuture<T>
    implements DurableExecutorServiceFuture<T> {
        private ClientDurableExecutorServiceCompletedFuture(Throwable throwable, Executor executor) {
            super(executor);
            super.completeExceptionally(throwable);
        }

        @Override
        public long getTaskId() {
            throw new IllegalStateException("Task failed to execute!");
        }
    }
}

