/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.executorservice;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceSubmitToPartitionCodec;
import com.hazelcast.client.impl.protocol.task.AbstractPartitionMessageTask;
import com.hazelcast.executor.impl.DistributedExecutorService;
import com.hazelcast.executor.impl.operations.CallableTaskOperation;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.security.SecureCallable;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.permission.ExecutorServicePermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;

public class ExecutorServiceSubmitToPartitionMessageTask
extends AbstractPartitionMessageTask<ExecutorServiceSubmitToPartitionCodec.RequestParameters> {
    public ExecutorServiceSubmitToPartitionMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
        this.setNamespaceAware();
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.clientEngine.getSecurityContext();
        Data callableData = ((ExecutorServiceSubmitToPartitionCodec.RequestParameters)this.parameters).callable;
        if (securityContext != null) {
            Subject subject = this.endpoint.getSubject();
            Object taskObject = this.serializationService.toObject(((ExecutorServiceSubmitToPartitionCodec.RequestParameters)this.parameters).callable);
            SecureCallable<Object> callable = taskObject instanceof Runnable ? securityContext.createSecureCallable(subject, (Runnable)taskObject) : securityContext.createSecureCallable(subject, (Callable)taskObject);
            callableData = this.serializationService.toData(callable);
        }
        return new CallableTaskOperation(((ExecutorServiceSubmitToPartitionCodec.RequestParameters)this.parameters).name, ((ExecutorServiceSubmitToPartitionCodec.RequestParameters)this.parameters).uuid, callableData);
    }

    @Override
    protected ExecutorServiceSubmitToPartitionCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ExecutorServiceSubmitToPartitionCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        Object data = this.serializationService.toData(response);
        return ExecutorServiceSubmitToPartitionCodec.encodeResponse(data);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new ExecutorServicePermission(((ExecutorServiceSubmitToPartitionCodec.RequestParameters)this.parameters).name, "modify");
    }

    @Override
    public String getDistributedObjectName() {
        return ((ExecutorServiceSubmitToPartitionCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "submitToPartition";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    protected String getUserCodeNamespace() {
        return DistributedExecutorService.lookupNamespace(this.nodeEngine, ((ExecutorServiceSubmitToPartitionCodec.RequestParameters)this.parameters).name);
    }
}

