/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnection;
import com.hazelcast.client.impl.connection.tcp.TpcChannelClientConnectionAdapter;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientTpcAuthenticationCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;

public final class TpcChannelConnector {
    private final HazelcastClientInstance client;
    private final long authenticationTimeoutMillis;
    private final UUID clientUuid;
    private final TcpClientConnection connection;
    private final List<Integer> tpcPorts;
    private final byte[] tpcToken;
    private final ExecutorService executor;
    private final BiFunction<Address, TcpClientConnection, Channel> channelCreator;
    private final ILogger logger;
    private final Channel[] tpcChannels;
    private final AtomicInteger remaining;
    private volatile boolean failed;

    public TpcChannelConnector(HazelcastClientInstance client, long authenticationTimeoutMillis, UUID clientUuid, TcpClientConnection connection, List<Integer> tpcPorts, byte[] tpcToken, ExecutorService executor, BiFunction<Address, TcpClientConnection, Channel> channelCreator, LoggingService loggingService) {
        this.client = client;
        this.authenticationTimeoutMillis = authenticationTimeoutMillis;
        this.clientUuid = clientUuid;
        this.connection = connection;
        this.tpcPorts = tpcPorts;
        this.tpcToken = tpcToken;
        this.executor = executor;
        this.channelCreator = channelCreator;
        this.logger = loggingService.getLogger(TpcChannelConnector.class);
        this.tpcChannels = new Channel[tpcPorts.size()];
        this.remaining = new AtomicInteger(tpcPorts.size());
    }

    public void initiate() {
        this.logger.info("Initiating connection attempts to TPC channels running on ports " + String.valueOf(this.tpcPorts) + " for " + String.valueOf(this.connection));
        String host = this.connection.getRemoteAddress().getHost();
        int i = 0;
        for (int port : this.tpcPorts) {
            int index = i++;
            this.executor.submit(() -> this.connect(host, port, index));
        }
    }

    private void connect(String host, int port, int index) {
        if (this.connectionFailed()) {
            this.logger.warning("The connection to TPC channel on port " + port + " for " + String.valueOf(this.connection) + " will not be made as either the connection or one of the TPC channel connections has failed.");
            return;
        }
        this.logger.info("Trying to connect to TPC channel on port " + port + " for " + String.valueOf(this.connection));
        Channel channel = null;
        try {
            Address address = this.translate(new Address(host, port));
            channel = this.channelCreator.apply(address, this.connection);
            this.authenticate(channel);
            this.onSuccessfulChannelConnection(channel, index);
        }
        catch (Exception e) {
            this.logger.warning("Exception during the connection to attempt to TPC channel on port " + port + " for " + String.valueOf(this.connection) + ": " + String.valueOf(e), e);
            this.onFailure(channel);
        }
    }

    private void authenticate(Channel channel) throws ExecutionException, InterruptedException, TimeoutException {
        ConcurrentMap attributeMap = channel.attributeMap();
        ClientConnection adapter = (ClientConnection)attributeMap.get(TpcChannelClientConnectionAdapter.class);
        ClientMessage request = ClientTpcAuthenticationCodec.encodeRequest(this.clientUuid, this.tpcToken);
        ClientInvocation invocation = new ClientInvocation(this.client, request, null, adapter);
        invocation.invokeUrgent().get(this.authenticationTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuccessfulChannelConnection(Channel channel, int index) {
        Channel[] channelArray = this.tpcChannels;
        synchronized (this.tpcChannels) {
            if (this.connectionFailed()) {
                this.logger.warning("Closing the TPC channel " + String.valueOf(channel) + " for " + String.valueOf(this.connection) + " as one of the connections is failed.");
                this.onFailure(channel);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            this.tpcChannels[index] = channel;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.logger.info("Successfully connected to TPC channel " + String.valueOf(channel) + " for " + String.valueOf(this.connection));
            if (this.remaining.decrementAndGet() == 0) {
                this.connection.setTpcChannels(this.tpcChannels);
                if (!this.connection.isAlive()) {
                    this.logger.warning("Closing all TPC channel connections for " + String.valueOf(this.connection) + " as the connection is closed.");
                    this.closeAllChannels();
                } else {
                    this.logger.info("All TPC channel connections are established for the " + String.valueOf(this.connection));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFailure(Channel channel) {
        Channel[] channelArray = this.tpcChannels;
        synchronized (this.tpcChannels) {
            this.closeChannel(channel);
            if (this.failed) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.failed = true;
            this.closeAllChannels();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.logger.warning("TPC channel establishments for the " + String.valueOf(this.connection) + " have failed. The client will not be using the TPC channels to route partition specific invocations, and fallback to the smart routing mode for this connection. Check the firewall settings to make sure the TPC channels are accessible from the client.");
            return;
        }
    }

    private boolean connectionFailed() {
        return this.failed || !this.connection.isAlive();
    }

    private void closeChannel(Channel channel) {
        IOUtil.closeResource(channel);
    }

    private void closeAllChannels() {
        for (Channel channel : this.tpcChannels) {
            this.closeChannel(channel);
        }
    }

    private Address translate(Address address) throws Exception {
        ConcurrentMap attributeMap = this.connection.attributeMap();
        CandidateClusterContext context = (CandidateClusterContext)attributeMap.get(CandidateClusterContext.class);
        AddressProvider provider = context.getAddressProvider();
        Address translated = provider.translate(address);
        if (translated == null) {
            throw new HazelcastException("Failed to translate " + String.valueOf(address) + " with " + String.valueOf(provider));
        }
        return translated;
    }
}

