/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.MemberInfo;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;

public final class AuthenticationResponse {
    private final byte status;
    private final Address address;
    private final UUID memberUuid;
    private final byte serializationVersion;
    private final String serverHazelcastVersion;
    private final int partitionCount;
    private final UUID clusterId;
    private final boolean failoverSupported;
    private final List<Integer> tpcPorts;
    private final byte[] tpcToken;
    private boolean isMemberListVersionExists;
    private boolean isPartitionListVersionExists;
    private int memberListVersion;
    private List<MemberInfo> memberInfos;
    private int partitionListVersion;
    private List<Map.Entry<UUID, List<Integer>>> partitions;

    private AuthenticationResponse(byte status, Address address, UUID memberUuid, byte serializationVersion, String serverHazelcastVersion, int partitionCount, UUID clusterId, boolean failoverSupported, List<Integer> tpcPorts, byte[] tpcToken, boolean isMemberListVersionExists, int memberListVersion, List<MemberInfo> memberInfos, boolean isPartitionListVersionExists, int partitionListVersion, List<Map.Entry<UUID, List<Integer>>> partitions) {
        this.status = status;
        this.address = address;
        this.memberUuid = memberUuid;
        this.serializationVersion = serializationVersion;
        this.serverHazelcastVersion = serverHazelcastVersion;
        this.partitionCount = partitionCount;
        this.clusterId = clusterId;
        this.failoverSupported = failoverSupported;
        this.tpcPorts = tpcPorts;
        this.tpcToken = tpcToken;
        this.isMemberListVersionExists = isMemberListVersionExists;
        this.memberListVersion = memberListVersion;
        this.memberInfos = memberInfos;
        this.isPartitionListVersionExists = isPartitionListVersionExists;
        this.partitionListVersion = partitionListVersion;
        this.partitions = partitions;
    }

    public byte getStatus() {
        return this.status;
    }

    @Nullable
    public Address getAddress() {
        return this.address;
    }

    @Nullable
    public UUID getMemberUuid() {
        return this.memberUuid;
    }

    public byte getSerializationVersion() {
        return this.serializationVersion;
    }

    public String getServerHazelcastVersion() {
        return this.serverHazelcastVersion;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public UUID getClusterId() {
        return this.clusterId;
    }

    public boolean isFailoverSupported() {
        return this.failoverSupported;
    }

    @Nullable
    public List<Integer> getTpcPorts() {
        return this.tpcPorts;
    }

    @Nullable
    public byte[] getTpcToken() {
        return this.tpcToken;
    }

    public int getMemberListVersion() {
        return this.memberListVersion;
    }

    public List<MemberInfo> getMemberInfos() {
        return this.memberInfos;
    }

    public int getPartitionListVersion() {
        return this.partitionListVersion;
    }

    public List<Map.Entry<UUID, List<Integer>>> getPartitions() {
        return this.partitions;
    }

    public boolean isMemberListVersionExists() {
        return this.isMemberListVersionExists;
    }

    public boolean isPartitionListVersionExists() {
        return this.isPartitionListVersionExists;
    }

    public static AuthenticationResponse from(ClientMessage message) {
        switch (message.getMessageType()) {
            case 257: {
                return AuthenticationResponse.fromAuthenticationCodec(message);
            }
            case 513: {
                return AuthenticationResponse.fromAuthenticationCustomCodec(message);
            }
        }
        throw new IllegalStateException("Unexpected response message type");
    }

    private static AuthenticationResponse fromAuthenticationCodec(ClientMessage message) {
        ClientAuthenticationCodec.ResponseParameters parameters = ClientAuthenticationCodec.decodeResponse(message);
        return new AuthenticationResponse(parameters.status, parameters.address, parameters.memberUuid, parameters.serializationVersion, parameters.serverHazelcastVersion, parameters.partitionCount, parameters.clusterId, parameters.failoverSupported, parameters.tpcPorts, parameters.tpcToken, parameters.isMemberListVersionExists, parameters.memberListVersion, parameters.memberInfos, parameters.isPartitionListVersionExists, parameters.partitionListVersion, parameters.partitions);
    }

    private static AuthenticationResponse fromAuthenticationCustomCodec(ClientMessage message) {
        ClientAuthenticationCustomCodec.ResponseParameters parameters = ClientAuthenticationCustomCodec.decodeResponse(message);
        return new AuthenticationResponse(parameters.status, parameters.address, parameters.memberUuid, parameters.serializationVersion, parameters.serverHazelcastVersion, parameters.partitionCount, parameters.clusterId, parameters.failoverSupported, parameters.tpcPorts, parameters.tpcToken, parameters.isMemberListVersionExists, parameters.memberListVersion, parameters.memberInfos, parameters.isPartitionListVersionExists, parameters.partitionListVersion, parameters.partitions);
    }
}

