/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.impl.connection.tcp.ClientProtocolEncoder;
import com.hazelcast.client.impl.connection.tcp.TcpClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.util.ClientMessageEncoder;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelOption;
import com.hazelcast.internal.nio.ssl.AbstractTLSChannelInitializer;
import java.util.concurrent.Executor;

public class ClientTLSChannelInitializer
extends AbstractTLSChannelInitializer {
    private final SocketOptions socketOptions;

    public ClientTLSChannelInitializer(SSLConfig sslConfig, Executor executor, SocketOptions socketOptions) {
        super(sslConfig, executor);
        this.socketOptions = socketOptions;
    }

    @Override
    protected void configChannel(Channel channel) {
        channel.options().setOption(ChannelOption.SO_SNDBUF, 1024 * this.socketOptions.getBufferSize()).setOption(ChannelOption.SO_RCVBUF, 1024 * this.socketOptions.getBufferSize()).setOption(ChannelOption.SO_REUSEADDR, this.socketOptions.isReuseAddress()).setOption(ChannelOption.SO_KEEPALIVE, this.socketOptions.isKeepAlive()).setOption(ChannelOption.SO_LINGER, this.socketOptions.getLingerSeconds()).setOption(ChannelOption.SO_TIMEOUT, 0).setOption(ChannelOption.TCP_NODELAY, this.socketOptions.isTcpNoDelay()).setOption(ChannelOption.DIRECT_BUF, false);
    }

    @Override
    protected void initPipeline(Channel channel) {
        TcpClientConnection connection = (TcpClientConnection)channel.attributeMap().get(TcpClientConnection.class);
        ClientMessageDecoder clientMessageDecoder = new ClientMessageDecoder(connection, message -> connection.handleClientMessage((ClientMessage)message), null);
        channel.inboundPipeline().addLast(clientMessageDecoder);
        channel.outboundPipeline().addLast(new ClientMessageEncoder());
        channel.outboundPipeline().addLast(new ClientProtocolEncoder());
    }

    @Override
    public boolean forClient() {
        return true;
    }
}

