/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientMetricsConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientSqlConfig;
import com.hazelcast.client.config.ClientTpcConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.client.config.impl.XmlClientConfigLocator;
import com.hazelcast.client.config.impl.YamlClientConfigLocator;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.config.DeclarativeConfigUtil;
import com.hazelcast.internal.config.override.ExternalConfigurationOverride;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.annotation.Beta;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class ClientConfig {
    private Properties properties = new Properties();
    private ClientSecurityConfig securityConfig = new ClientSecurityConfig();
    private ClientNetworkConfig networkConfig = new ClientNetworkConfig();
    private LoadBalancer loadBalancer;
    private String loadBalancerClassName;
    private final List<ListenerConfig> listenerConfigs;
    private String instanceName;
    private String clusterName = "dev";
    private ConfigPatternMatcher configPatternMatcher = new MatchingPointConfigPatternMatcher();
    private final Map<String, NearCacheConfig> nearCacheConfigMap;
    private final Map<String, ClientReliableTopicConfig> reliableTopicConfigMap;
    private final Map<String, Map<String, QueryCacheConfig>> queryCacheConfigs;
    private SerializationConfig serializationConfig = new SerializationConfig();
    private NativeMemoryConfig nativeMemoryConfig = new NativeMemoryConfig();
    private final List<ProxyFactoryConfig> proxyFactoryConfigs;
    private ManagedContext managedContext;
    private ClassLoader classLoader;
    private ClientConnectionStrategyConfig connectionStrategyConfig = new ClientConnectionStrategyConfig();
    private ClientUserCodeDeploymentConfig userCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
    private boolean backupAckToClientEnabled = true;
    private final Map<String, ClientFlakeIdGeneratorConfig> flakeIdGeneratorConfigMap;
    private final Set<String> labels;
    private final ConcurrentMap<String, Object> userContext;
    private ClientMetricsConfig metricsConfig = new ClientMetricsConfig();
    private InstanceTrackingConfig instanceTrackingConfig = new InstanceTrackingConfig();
    private ClientSqlConfig sqlConfig = new ClientSqlConfig();
    private ClientTpcConfig tpcConfig = new ClientTpcConfig();

    public ClientConfig() {
        this.listenerConfigs = new LinkedList<ListenerConfig>();
        this.nearCacheConfigMap = new ConcurrentHashMap<String, NearCacheConfig>();
        this.reliableTopicConfigMap = new ConcurrentHashMap<String, ClientReliableTopicConfig>();
        this.proxyFactoryConfigs = new LinkedList<ProxyFactoryConfig>();
        this.flakeIdGeneratorConfigMap = new ConcurrentHashMap<String, ClientFlakeIdGeneratorConfig>();
        this.queryCacheConfigs = new ConcurrentHashMap<String, Map<String, QueryCacheConfig>>();
        this.labels = new HashSet<String>();
        this.userContext = new ConcurrentHashMap<String, Object>();
    }

    public ClientConfig(ClientConfig config) {
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)config.properties);
        this.clusterName = config.clusterName;
        this.securityConfig = new ClientSecurityConfig(config.securityConfig);
        this.networkConfig = new ClientNetworkConfig(config.networkConfig);
        this.loadBalancer = config.loadBalancer;
        this.loadBalancerClassName = config.loadBalancerClassName;
        this.listenerConfigs = new LinkedList<ListenerConfig>();
        for (ListenerConfig listenerConfig : config.listenerConfigs) {
            this.listenerConfigs.add(new ListenerConfig(listenerConfig));
        }
        this.instanceName = config.instanceName;
        this.configPatternMatcher = config.configPatternMatcher;
        this.nearCacheConfigMap = new ConcurrentHashMap<String, NearCacheConfig>();
        for (Map.Entry entry : config.nearCacheConfigMap.entrySet()) {
            this.nearCacheConfigMap.put((String)entry.getKey(), new NearCacheConfig((NearCacheConfig)entry.getValue()));
        }
        this.reliableTopicConfigMap = new ConcurrentHashMap<String, ClientReliableTopicConfig>();
        for (Map.Entry entry : config.reliableTopicConfigMap.entrySet()) {
            this.reliableTopicConfigMap.put((String)entry.getKey(), new ClientReliableTopicConfig((ClientReliableTopicConfig)entry.getValue()));
        }
        this.queryCacheConfigs = new ConcurrentHashMap<String, Map<String, QueryCacheConfig>>();
        for (Map.Entry entry : config.queryCacheConfigs.entrySet()) {
            Map value = (Map)entry.getValue();
            ConcurrentHashMap<String, QueryCacheConfig> map = new ConcurrentHashMap<String, QueryCacheConfig>();
            for (Map.Entry cacheConfigEntry : value.entrySet()) {
                map.put((String)cacheConfigEntry.getKey(), new QueryCacheConfig((QueryCacheConfig)cacheConfigEntry.getValue()));
            }
            this.queryCacheConfigs.put((String)entry.getKey(), map);
        }
        this.serializationConfig = new SerializationConfig(config.serializationConfig);
        this.nativeMemoryConfig = new NativeMemoryConfig(config.nativeMemoryConfig);
        this.proxyFactoryConfigs = new LinkedList<ProxyFactoryConfig>();
        for (ProxyFactoryConfig proxyFactoryConfig : config.proxyFactoryConfigs) {
            this.proxyFactoryConfigs.add(new ProxyFactoryConfig(proxyFactoryConfig));
        }
        this.managedContext = config.managedContext;
        this.classLoader = config.classLoader;
        this.connectionStrategyConfig = new ClientConnectionStrategyConfig(config.connectionStrategyConfig);
        this.userCodeDeploymentConfig = new ClientUserCodeDeploymentConfig(config.userCodeDeploymentConfig);
        this.backupAckToClientEnabled = config.backupAckToClientEnabled;
        this.flakeIdGeneratorConfigMap = new ConcurrentHashMap<String, ClientFlakeIdGeneratorConfig>();
        for (Map.Entry entry : config.flakeIdGeneratorConfigMap.entrySet()) {
            this.flakeIdGeneratorConfigMap.put((String)entry.getKey(), new ClientFlakeIdGeneratorConfig((ClientFlakeIdGeneratorConfig)entry.getValue()));
        }
        this.labels = new HashSet<String>(config.labels);
        this.userContext = new ConcurrentHashMap<String, Object>(config.userContext);
        this.metricsConfig = new ClientMetricsConfig(config.metricsConfig);
        this.instanceTrackingConfig = new InstanceTrackingConfig(config.instanceTrackingConfig);
        this.sqlConfig = new ClientSqlConfig(config.sqlConfig);
        this.tpcConfig = new ClientTpcConfig(config.tpcConfig);
    }

    public static ClientConfig load() {
        return new ExternalConfigurationOverride().overwriteClientConfig(ClientConfig.loadFromFile());
    }

    private static ClientConfig loadFromFile() {
        DeclarativeConfigUtil.validateSuffixInSystemProperty("hazelcast.client.config");
        XmlClientConfigLocator xmlConfigLocator = new XmlClientConfigLocator();
        YamlClientConfigLocator yamlConfigLocator = new YamlClientConfigLocator();
        if (xmlConfigLocator.locateFromSystemProperty()) {
            return new XmlClientConfigBuilder(xmlConfigLocator).build();
        }
        if (yamlConfigLocator.locateFromSystemProperty()) {
            return new YamlClientConfigBuilder(yamlConfigLocator).build();
        }
        if (xmlConfigLocator.locateInWorkDirOrOnClasspath()) {
            return new XmlClientConfigBuilder(xmlConfigLocator).build();
        }
        if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            return new YamlClientConfigBuilder(yamlConfigLocator).build();
        }
        xmlConfigLocator.locateDefault();
        return new XmlClientConfigBuilder(xmlConfigLocator).build();
    }

    public ClientConfig setConfigPatternMatcher(ConfigPatternMatcher configPatternMatcher) {
        Preconditions.isNotNull(configPatternMatcher, "configPatternMatcher");
        this.configPatternMatcher = configPatternMatcher;
        return this;
    }

    public ConfigPatternMatcher getConfigPatternMatcher() {
        return this.configPatternMatcher;
    }

    public String getProperty(String name) {
        String value = this.properties.getProperty(name);
        return value != null ? value : System.getProperty(name);
    }

    public ClientConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClientConfig setProperties(Properties properties) {
        Preconditions.isNotNull(properties, "properties");
        this.properties = properties;
        return this;
    }

    public ClientSecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public ClientConfig setSecurityConfig(ClientSecurityConfig securityConfig) {
        Preconditions.isNotNull(securityConfig, "securityConfig");
        this.securityConfig = securityConfig;
        return this;
    }

    public ClientConfig setCredentials(Credentials credentials) {
        this.getSecurityConfig().setCredentials(credentials);
        return this;
    }

    public ClientNetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public ClientConfig setNetworkConfig(ClientNetworkConfig networkConfig) {
        Preconditions.isNotNull(networkConfig, "networkConfig");
        this.networkConfig = networkConfig;
        return this;
    }

    public ClientConfig addReliableTopicConfig(ClientReliableTopicConfig reliableTopicConfig) {
        this.reliableTopicConfigMap.put(reliableTopicConfig.getName(), reliableTopicConfig);
        return this;
    }

    public ClientReliableTopicConfig getReliableTopicConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.reliableTopicConfigMap, name, ClientReliableTopicConfig.class, ClientReliableTopicConfig::setName);
    }

    public ClientConfig addNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfigMap.put(nearCacheConfig.getName(), nearCacheConfig);
        return this;
    }

    public ClientConfig addListenerConfig(ListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public ClientConfig addProxyFactoryConfig(ProxyFactoryConfig proxyFactoryConfig) {
        this.proxyFactoryConfigs.add(proxyFactoryConfig);
        return this;
    }

    public NearCacheConfig getNearCacheConfig(String name) {
        NearCacheConfig nearCacheConfig = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.nearCacheConfigMap, name);
        if (nearCacheConfig == null && (nearCacheConfig = this.nearCacheConfigMap.get("default")) != null) {
            nearCacheConfig = new NearCacheConfig(nearCacheConfig);
        }
        return nearCacheConfig;
    }

    public Map<String, NearCacheConfig> getNearCacheConfigMap() {
        return this.nearCacheConfigMap;
    }

    public ClientConfig setNearCacheConfigMap(Map<String, NearCacheConfig> nearCacheConfigMap) {
        Preconditions.isNotNull(nearCacheConfigMap, "nearCacheConfigMap");
        this.nearCacheConfigMap.clear();
        this.nearCacheConfigMap.putAll(nearCacheConfigMap);
        for (Map.Entry<String, NearCacheConfig> entry : this.nearCacheConfigMap.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, ClientFlakeIdGeneratorConfig> getFlakeIdGeneratorConfigMap() {
        return this.flakeIdGeneratorConfigMap;
    }

    public ClientFlakeIdGeneratorConfig findFlakeIdGeneratorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ClientFlakeIdGeneratorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.flakeIdGeneratorConfigMap, baseName);
        if (config != null) {
            return config;
        }
        return this.getFlakeIdGeneratorConfig("default");
    }

    public ClientFlakeIdGeneratorConfig getFlakeIdGeneratorConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.getFlakeIdGeneratorConfigMap(), name, ClientFlakeIdGeneratorConfig.class, ClientFlakeIdGeneratorConfig::setName);
    }

    public ClientConfig addFlakeIdGeneratorConfig(ClientFlakeIdGeneratorConfig config) {
        this.flakeIdGeneratorConfigMap.put(config.getName(), config);
        return this;
    }

    public ClientConfig setFlakeIdGeneratorConfigMap(Map<String, ClientFlakeIdGeneratorConfig> map) {
        Preconditions.isNotNull(map, "flakeIdGeneratorConfigMap");
        this.flakeIdGeneratorConfigMap.clear();
        this.flakeIdGeneratorConfigMap.putAll(map);
        for (Map.Entry<String, ClientFlakeIdGeneratorConfig> entry : map.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ClientConfig setReliableTopicConfigMap(Map<String, ClientReliableTopicConfig> map) {
        Preconditions.isNotNull(map, "reliableTopicConfigMap");
        this.reliableTopicConfigMap.clear();
        this.reliableTopicConfigMap.putAll(map);
        for (Map.Entry<String, ClientReliableTopicConfig> entry : map.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, ClientReliableTopicConfig> getReliableTopicConfigMap() {
        return this.reliableTopicConfigMap;
    }

    public List<ListenerConfig> getListenerConfigs() {
        return this.listenerConfigs;
    }

    public ClientConfig setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        Preconditions.isNotNull(listenerConfigs, "listenerConfigs");
        this.listenerConfigs.clear();
        this.listenerConfigs.addAll(listenerConfigs);
        return this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientConfig setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        this.loadBalancerClassName = null;
        return this;
    }

    public String getLoadBalancerClassName() {
        return this.loadBalancerClassName;
    }

    public ClientConfig setLoadBalancerClassName(@Nonnull String loadBalancerClassName) {
        this.loadBalancerClassName = Preconditions.checkHasText(loadBalancerClassName, "Load balancer class name must contain text");
        this.loadBalancer = null;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClientConfig setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ManagedContext getManagedContext() {
        return this.managedContext;
    }

    public ClientConfig setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public List<ProxyFactoryConfig> getProxyFactoryConfigs() {
        return this.proxyFactoryConfigs;
    }

    public ClientConfig setProxyFactoryConfigs(List<ProxyFactoryConfig> proxyFactoryConfigs) {
        Preconditions.isNotNull(proxyFactoryConfigs, "proxyFactoryConfigs");
        this.proxyFactoryConfigs.clear();
        this.proxyFactoryConfigs.addAll(proxyFactoryConfigs);
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public ClientConfig setSerializationConfig(SerializationConfig serializationConfig) {
        Preconditions.isNotNull(serializationConfig, "serializationConfig");
        this.serializationConfig = serializationConfig;
        return this;
    }

    public NativeMemoryConfig getNativeMemoryConfig() {
        return this.nativeMemoryConfig;
    }

    public ClientConfig setNativeMemoryConfig(NativeMemoryConfig nativeMemoryConfig) {
        Preconditions.isNotNull(nativeMemoryConfig, "nativeMemoryConfig");
        this.nativeMemoryConfig = nativeMemoryConfig;
        return this;
    }

    public ClientConfig addQueryCacheConfig(String mapName, QueryCacheConfig queryCacheConfig) {
        Map<String, Map<String, QueryCacheConfig>> queryCacheConfigsPerMap = this.getQueryCacheConfigs();
        String queryCacheName = queryCacheConfig.getName();
        Map<String, QueryCacheConfig> queryCacheConfigs = queryCacheConfigsPerMap.get(mapName);
        if (queryCacheConfigs != null) {
            Preconditions.checkFalse(queryCacheConfigs.containsKey(queryCacheName), "A query cache already exists with name = [" + queryCacheName + "]");
        } else {
            queryCacheConfigs = new ConcurrentHashMap<String, QueryCacheConfig>();
            queryCacheConfigsPerMap.put(mapName, queryCacheConfigs);
        }
        queryCacheConfigs.put(queryCacheName, queryCacheConfig);
        return this;
    }

    public Map<String, Map<String, QueryCacheConfig>> getQueryCacheConfigs() {
        return this.queryCacheConfigs;
    }

    public ClientConfig setQueryCacheConfigs(Map<String, Map<String, QueryCacheConfig>> queryCacheConfigs) {
        Preconditions.isNotNull(queryCacheConfigs, "queryCacheConfigs");
        this.queryCacheConfigs.clear();
        this.queryCacheConfigs.putAll(queryCacheConfigs);
        return this;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public ClientConfig setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClientConfig setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public ClientConnectionStrategyConfig getConnectionStrategyConfig() {
        return this.connectionStrategyConfig;
    }

    public ClientConfig setConnectionStrategyConfig(ClientConnectionStrategyConfig connectionStrategyConfig) {
        Preconditions.isNotNull(connectionStrategyConfig, "connectionStrategyConfig");
        this.connectionStrategyConfig = connectionStrategyConfig;
        return this;
    }

    public ClientUserCodeDeploymentConfig getUserCodeDeploymentConfig() {
        return this.userCodeDeploymentConfig;
    }

    public ClientConfig setUserCodeDeploymentConfig(ClientUserCodeDeploymentConfig userCodeDeploymentConfig) {
        Preconditions.isNotNull(userCodeDeploymentConfig, "userCodeDeploymentConfig");
        this.userCodeDeploymentConfig = userCodeDeploymentConfig;
        return this;
    }

    public QueryCacheConfig getOrCreateQueryCacheConfig(String mapName, String cacheName) {
        QueryCacheConfig queryCacheConfig;
        Map<String, Map<String, QueryCacheConfig>> allQueryCacheConfig = this.getQueryCacheConfigs();
        Map<String, QueryCacheConfig> queryCacheConfigsForMap = ConfigUtils.lookupByPattern(this.configPatternMatcher, allQueryCacheConfig, mapName);
        if (queryCacheConfigsForMap == null) {
            queryCacheConfigsForMap = new HashMap<String, QueryCacheConfig>();
            allQueryCacheConfig.put(mapName, queryCacheConfigsForMap);
        }
        if ((queryCacheConfig = ConfigUtils.lookupByPattern(this.configPatternMatcher, queryCacheConfigsForMap, cacheName)) == null) {
            queryCacheConfig = new QueryCacheConfig(cacheName);
            queryCacheConfigsForMap.put(cacheName, queryCacheConfig);
        }
        return queryCacheConfig;
    }

    public QueryCacheConfig getOrNullQueryCacheConfig(String mapName, String cacheName) {
        if (this.queryCacheConfigs == null) {
            return null;
        }
        Map<String, QueryCacheConfig> queryCacheConfigsForMap = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.queryCacheConfigs, mapName);
        if (queryCacheConfigsForMap == null) {
            return null;
        }
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, queryCacheConfigsForMap, cacheName);
    }

    public ClientConfig addLabel(String label) {
        Preconditions.isNotNull(label, "label");
        this.labels.add(label);
        return this;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public ClientConfig setLabels(Set<String> labels) {
        Preconditions.isNotNull(labels, "labels");
        this.labels.clear();
        this.labels.addAll(labels);
        return this;
    }

    public ClientConfig setUserContext(ConcurrentMap<String, Object> userContext) {
        Preconditions.isNotNull(userContext, "userContext");
        this.userContext.clear();
        this.userContext.putAll(userContext);
        return this;
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig setBackupAckToClientEnabled(boolean backupAckToClientEnabled) {
        this.backupAckToClientEnabled = backupAckToClientEnabled;
        return this;
    }

    public boolean isBackupAckToClientEnabled() {
        return this.backupAckToClientEnabled;
    }

    @Nonnull
    public ClientMetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Nonnull
    public ClientConfig setMetricsConfig(@Nonnull ClientMetricsConfig metricsConfig) {
        Preconditions.isNotNull(metricsConfig, "metricsConfig");
        this.metricsConfig = metricsConfig;
        return this;
    }

    @Nonnull
    public InstanceTrackingConfig getInstanceTrackingConfig() {
        return this.instanceTrackingConfig;
    }

    @Nonnull
    public ClientConfig setInstanceTrackingConfig(@Nonnull InstanceTrackingConfig instanceTrackingConfig) {
        Preconditions.isNotNull(instanceTrackingConfig, "instanceTrackingConfig");
        this.instanceTrackingConfig = instanceTrackingConfig;
        return this;
    }

    @Nonnull
    public ClientSqlConfig getSqlConfig() {
        return this.sqlConfig;
    }

    @Nonnull
    public ClientConfig setSqlConfig(ClientSqlConfig sqlConfig) {
        Preconditions.isNotNull(sqlConfig, "sqlConfig");
        this.sqlConfig = sqlConfig;
        return this;
    }

    @Beta
    @Nonnull
    public ClientTpcConfig getTpcConfig() {
        return this.tpcConfig;
    }

    @Beta
    @Nonnull
    public ClientConfig setTpcConfig(@Nonnull ClientTpcConfig tpcConfig) {
        this.tpcConfig = Preconditions.isNotNull(tpcConfig, "tpcConfig");
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.backupAckToClientEnabled, this.classLoader, this.clusterName, this.configPatternMatcher, this.connectionStrategyConfig, this.flakeIdGeneratorConfigMap, this.instanceName, this.labels, this.listenerConfigs, this.loadBalancer, this.loadBalancerClassName, this.managedContext, this.metricsConfig, this.nativeMemoryConfig, this.nearCacheConfigMap, this.networkConfig, this.properties, this.proxyFactoryConfigs, this.queryCacheConfigs, this.reliableTopicConfigMap, this.securityConfig, this.serializationConfig, this.userCodeDeploymentConfig, this.userContext, this.instanceTrackingConfig, this.sqlConfig, this.tpcConfig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)obj;
        return this.backupAckToClientEnabled == other.backupAckToClientEnabled && Objects.equals(this.classLoader, other.classLoader) && Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.configPatternMatcher, other.configPatternMatcher) && Objects.equals(this.connectionStrategyConfig, other.connectionStrategyConfig) && Objects.equals(this.flakeIdGeneratorConfigMap, other.flakeIdGeneratorConfigMap) && Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.labels, other.labels) && Objects.equals(this.listenerConfigs, other.listenerConfigs) && Objects.equals(this.loadBalancer, other.loadBalancer) && Objects.equals(this.loadBalancerClassName, other.loadBalancerClassName) && Objects.equals(this.managedContext, other.managedContext) && Objects.equals(this.metricsConfig, other.metricsConfig) && Objects.equals(this.nativeMemoryConfig, other.nativeMemoryConfig) && Objects.equals(this.nearCacheConfigMap, other.nearCacheConfigMap) && Objects.equals(this.networkConfig, other.networkConfig) && Objects.equals(this.properties, other.properties) && Objects.equals(this.proxyFactoryConfigs, other.proxyFactoryConfigs) && Objects.equals(this.queryCacheConfigs, other.queryCacheConfigs) && Objects.equals(this.reliableTopicConfigMap, other.reliableTopicConfigMap) && Objects.equals(this.securityConfig, other.securityConfig) && Objects.equals(this.serializationConfig, other.serializationConfig) && Objects.equals(this.userCodeDeploymentConfig, other.userCodeDeploymentConfig) && Objects.equals(this.userContext, other.userContext) && Objects.equals(this.instanceTrackingConfig, other.instanceTrackingConfig) && Objects.equals(this.sqlConfig, other.sqlConfig) && Objects.equals(this.tpcConfig, other.tpcConfig);
    }

    public String toString() {
        return "ClientConfig{properties=" + String.valueOf(this.properties) + ", clusterName=" + this.clusterName + ", securityConfig=" + String.valueOf(this.securityConfig) + ", networkConfig=" + String.valueOf(this.networkConfig) + ", loadBalancer=" + String.valueOf(this.loadBalancer) + ", loadBalancerClassName=" + this.loadBalancerClassName + ", listenerConfigs=" + String.valueOf(this.listenerConfigs) + ", instanceName='" + this.instanceName + "', configPatternMatcher=" + String.valueOf(this.configPatternMatcher) + ", nearCacheConfigMap=" + String.valueOf(this.nearCacheConfigMap) + ", reliableTopicConfigMap=" + String.valueOf(this.reliableTopicConfigMap) + ", queryCacheConfigs=" + String.valueOf(this.queryCacheConfigs) + ", serializationConfig=" + String.valueOf(this.serializationConfig) + ", nativeMemoryConfig=" + String.valueOf(this.nativeMemoryConfig) + ", proxyFactoryConfigs=" + String.valueOf(this.proxyFactoryConfigs) + ", connectionStrategyConfig=" + String.valueOf(this.connectionStrategyConfig) + ", userCodeDeploymentConfig=" + String.valueOf(this.userCodeDeploymentConfig) + ", backupAckToClientEnabled=" + this.backupAckToClientEnabled + ", flakeIdGeneratorConfigMap=" + String.valueOf(this.flakeIdGeneratorConfigMap) + ", labels=" + String.valueOf(this.labels) + ", metricsConfig=" + String.valueOf(this.metricsConfig) + ", instanceTrackingConfig=" + String.valueOf(this.instanceTrackingConfig) + ", sqlConfig=" + String.valueOf(this.sqlConfig) + ", tpcConfig=" + String.valueOf(this.tpcConfig) + "}";
    }
}

