/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.wan;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.cache.impl.wan.WanCacheEntryView;
import com.hazelcast.cache.impl.wan.WanEnterpriseCacheEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.WanEventType;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WanEnterpriseCacheAddOrUpdateEvent
extends WanEnterpriseCacheEvent<CacheEntryView<Object, Object>> {
    private String mergePolicy;
    private WanCacheEntryView<Object, Object> entryView;

    public WanEnterpriseCacheAddOrUpdateEvent(@Nonnull String cacheName, @Nonnull String mergePolicy, @Nonnull WanCacheEntryView<Object, Object> entryView, String managerPrefix, int backupCount) {
        super(cacheName, managerPrefix, backupCount);
        this.mergePolicy = mergePolicy;
        this.entryView = entryView;
    }

    public WanEnterpriseCacheAddOrUpdateEvent() {
    }

    public String getMergePolicy() {
        return this.mergePolicy;
    }

    public WanCacheEntryView<Object, Object> getEntryView() {
        return this.entryView;
    }

    @Override
    @Nonnull
    public Data getKey() {
        return this.entryView.getDataKey();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeString(this.mergePolicy);
        out.writeObject(this.entryView);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.mergePolicy = in.readString();
        this.entryView = (WanCacheEntryView)in.readObject();
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    public void incrementEventCount(@Nonnull WanEventCounters counters) {
        counters.incrementUpdate(this.getCacheName());
    }

    @Override
    @Nonnull
    public WanEventType getEventType() {
        return WanEventType.ADD_OR_UPDATE;
    }

    @Override
    @Nullable
    public CacheEntryView<Object, Object> getEventObject() {
        return this.entryView;
    }
}

