/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.wan;

import com.hazelcast.cache.wan.CacheWanEventFilter;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CacheFilterProvider {
    private final ConcurrentMap<String, CacheWanEventFilter> filterMap;
    private final NodeEngine nodeEngine;
    private final ConstructorFunction<String, CacheWanEventFilter> filterConstructorFunction = new ConstructorFunction<String, CacheWanEventFilter>(){

        @Override
        public CacheWanEventFilter createNew(String className) {
            try {
                return (CacheWanEventFilter)ClassLoaderUtil.newInstance(CacheFilterProvider.this.nodeEngine.getConfigClassLoader(), className);
            }
            catch (Exception e) {
                CacheFilterProvider.this.nodeEngine.getLogger(this.getClass()).severe(e);
                throw ExceptionUtil.rethrow(e);
            }
        }
    };

    public CacheFilterProvider(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.filterMap = new ConcurrentHashMap<String, CacheWanEventFilter>();
    }

    public CacheWanEventFilter getFilter(String className) {
        Objects.requireNonNull(className, "Class name is mandatory!");
        return ConcurrencyUtil.getOrPutIfAbsent(this.filterMap, className, this.filterConstructorFunction);
    }
}

