/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.operation.CacheRemoveBackupOperation;
import com.hazelcast.cache.impl.operation.EnterpriseCacheDataSerializerHook;
import com.hazelcast.cache.impl.operation.MutatingCacheOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.impl.CallerProvenance;
import java.io.IOException;
import java.util.UUID;

public class WanCacheRemoveOperation
extends MutatingCacheOperation {
    private UUID origin;

    public WanCacheRemoveOperation() {
    }

    public WanCacheRemoveOperation(String name, UUID origin, Data key, int completionId) {
        super(name, key, completionId);
        this.origin = origin;
    }

    @Override
    public void run() throws Exception {
        this.response = this.recordStore.remove(this.key, this.getCallerUuid(), this.origin, this.completionId, CallerProvenance.WAN);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheRemoveBackupOperation(this.name, this.key, true);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.origin);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.origin = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public int getFactoryId() {
        return EnterpriseCacheDataSerializerHook.F_ID;
    }
}

