/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.hazelcast.cache.impl.EnterpriseCacheServiceExtension;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheDataSerializerHook;
import com.hazelcast.cache.impl.operation.CacheOperation;
import com.hazelcast.internal.nio.EnterpriseObjectDataInput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.logging.Level;

abstract class HiDensityCacheOperation
extends CacheOperation {
    static final int UNIT_PERCENTAGE = 100;
    static final int FORCED_EVICTION_RETRY_COUNT = 5;
    protected Object response;
    protected int completionId = -1;
    protected transient boolean runCompleted;
    protected transient NativeOutOfMemoryError oome;
    protected transient EnterpriseSerializationService serializationService;
    protected transient EnterpriseCacheServiceExtension cacheService;

    protected HiDensityCacheOperation() {
    }

    protected HiDensityCacheOperation(String name) {
        this(name, -1, false);
    }

    protected HiDensityCacheOperation(String name, boolean dontCreateCacheRecordStoreIfNotExist) {
        this(name, -1, dontCreateCacheRecordStoreIfNotExist);
    }

    protected HiDensityCacheOperation(String name, int completionId) {
        this(name, completionId, false);
    }

    protected HiDensityCacheOperation(String name, int completionId, boolean dontCreateCacheRecordStoreIfNotExist) {
        super(name);
        this.completionId = completionId;
        this.dontCreateCacheRecordStoreIfNotExist = dontCreateCacheRecordStoreIfNotExist;
    }

    @Override
    public int getFactoryId() {
        return HiDensityCacheDataSerializerHook.F_ID;
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    @Override
    protected void beforeRunInternal() {
        this.ensureInitialized();
    }

    private void ensureInitialized() {
        if (this.cacheService == null || this.serializationService == null) {
            this.cacheService = (EnterpriseCacheServiceExtension)this.getService();
            this.serializationService = (EnterpriseSerializationService)this.getNodeEngine().getSerializationService();
        }
    }

    @Override
    public final void run() throws Exception {
        try {
            this.runInternal();
        }
        catch (NativeOutOfMemoryError e) {
            this.forceEvictAndRunInternal();
        }
        this.runCompleted = true;
    }

    protected abstract void runInternal() throws Exception;

    @Override
    public void afterRun() throws Exception {
        try {
            super.afterRun();
        }
        finally {
            this.disposeDeferredBlocks();
        }
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        this.dispose();
        super.onExecutionFailure(e);
    }

    @Override
    protected final void dispose() {
        this.ensureInitialized();
        this.disposeDeferredBlocks();
        try {
            this.disposeInternal(this.serializationService);
        }
        catch (Throwable e) {
            this.getLogger().warning("Error while disposing internal...", e);
        }
    }

    protected void disposeInternal(EnterpriseSerializationService serializationService) {
    }

    @Override
    public final void logError(Throwable e) {
        if (e instanceof NativeOutOfMemoryError) {
            Level level = this instanceof BackupOperation ? Level.FINEST : Level.WARNING;
            this.getLogger().log(level, "Cannot complete operation! -> " + e.getMessage());
            return;
        }
        super.logError(e);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.completionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.completionId = in.readInt();
    }

    public final int getCompletionId() {
        return this.completionId;
    }

    public final void setCompletionId(int completionId) {
        this.completionId = completionId;
    }

    private void forceEvictAndRunInternal() throws Exception {
        this.tryRunInternalByForceEviction();
        this.tryRunInternalByClearing();
        if (this.oome != null) {
            this.dispose();
            throw this.oome;
        }
    }

    private void tryRunInternalByForceEviction() throws Exception {
        int i;
        ILogger logger = this.getLogger();
        for (i = 0; i < 5; ++i) {
            try {
                if (logger.isFineEnabled()) {
                    logger.fine(String.format("Applying forced eviction on current RecordStore (cache %s, partitionId: %d)!", this.name, this.getPartitionId()));
                }
                this.forceEvict();
                this.runInternal();
                this.oome = null;
                break;
            }
            catch (NativeOutOfMemoryError e) {
                this.oome = e;
                continue;
            }
        }
        if (this.oome != null) {
            for (i = 0; i < 5; ++i) {
                try {
                    if (logger.isFineEnabled()) {
                        logger.fine(String.format("Applying forced eviction on other RecordStores owned by the same partition thread (cache %s, partitionId: %d", this.name, this.getPartitionId()));
                    }
                    this.forceEvictOnOthers();
                    this.runInternal();
                    this.oome = null;
                    break;
                }
                catch (NativeOutOfMemoryError e) {
                    this.oome = e;
                    continue;
                }
            }
        }
    }

    private void forceEvict() {
        this.cacheService.forceEvict(this.name, this.getPartitionId());
    }

    private void forceEvictOnOthers() {
        this.cacheService.forceEvictOnOthers(this.name, this.getPartitionId());
    }

    private void tryRunInternalByClearing() throws Exception {
        ILogger logger = this.getLogger();
        if (this.oome != null) {
            try {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Clearing current RecordStore because forced eviction was not enough!");
                }
                this.recordStore.clear();
                this.cacheService.sendInvalidationEvent(this.recordStore.getName(), null, AbstractCacheRecordStore.SOURCE_NOT_AVAILABLE);
                this.runInternal();
                this.oome = null;
            }
            catch (NativeOutOfMemoryError e) {
                this.oome = e;
            }
        }
        if (this.oome != null) {
            try {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Clearing other RecordStores owned by the same partition thread because forced eviction was not enough!");
                }
                this.cacheService.clearAll(this.getPartitionId());
                this.runInternal();
                this.oome = null;
            }
            catch (NativeOutOfMemoryError e) {
                this.oome = e;
            }
        }
    }

    private void disposeDeferredBlocks() {
        try {
            ICacheService service = (ICacheService)this.getService();
            HiDensityCacheRecordStore recordStore = (HiDensityCacheRecordStore)service.getRecordStore(this.name, this.getPartitionId());
            if (recordStore != null) {
                recordStore.disposeDeferredBlocks();
            }
        }
        catch (Throwable e) {
            this.getLogger().warning("Error while freeing deferred memory blocks...", e);
        }
    }

    public static Data readHeapOperationData(ObjectDataInput in) throws IOException {
        return ((EnterpriseObjectDataInput)in).tryReadData(DataType.HEAP);
    }

    public static Data readNativeMemoryOperationData(ObjectDataInput in) throws IOException {
        return ((EnterpriseObjectDataInput)in).tryReadData(DataType.NATIVE);
    }
}

