/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.nativememory;

import com.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.cache.impl.CacheMergeResponse;
import com.hazelcast.cache.impl.EnterpriseCachePartitionSegment;
import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.cache.impl.EnterpriseCacheServiceExtension;
import com.hazelcast.cache.impl.hidensity.HiDensityCacheRecordStore;
import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityFreeNativeMemoryPercentageEvictionChecker;
import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityFreeNativeMemorySizeEvictionChecker;
import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityUsedNativeMemoryPercentageEvictionChecker;
import com.hazelcast.cache.impl.hidensity.maxsize.HiDensityUsedNativeMemorySizeEvictionChecker;
import com.hazelcast.cache.impl.hidensity.nativememory.CacheHiDensityRecordProcessor;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheEntryProcessorEntry;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecord;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecordAccessor;
import com.hazelcast.cache.impl.hidensity.nativememory.HiDensityNativeMemoryCacheRecordMap;
import com.hazelcast.cache.impl.hidensity.nativememory.MerkleTreeRSMutationObserver;
import com.hazelcast.cache.impl.record.CacheDataRecord;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.comparators.NativeValueComparator;
import com.hazelcast.internal.util.comparators.ValueComparator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;

public class HiDensityNativeMemoryCacheRecordStore
extends AbstractCacheRecordStore<HiDensityNativeMemoryCacheRecord, HiDensityNativeMemoryCacheRecordMap>
implements HiDensityCacheRecordStore<HiDensityNativeMemoryCacheRecord> {
    private static final int NATIVE_MEMORY_DEFAULT_INITIAL_CAPACITY = 128;
    protected HiDensityStorageInfo cacheInfo;
    protected HazelcastMemoryManager memoryManager;
    protected EnterpriseSerializationService serializationService;
    protected HiDensityRecordProcessor<HiDensityNativeMemoryCacheRecord> cacheRecordProcessor;
    private final ILogger logger;

    public HiDensityNativeMemoryCacheRecordStore(int partitionId, String cacheNameWithPrefix, EnterpriseCacheService cacheService, NodeEngine nodeEngine) {
        super(cacheNameWithPrefix, partitionId, nodeEngine, cacheService);
        this.logger = nodeEngine.getLogger(this.getClass());
        this.ensureInitialized();
    }

    @Override
    protected void addMutationObservers() {
        super.addMutationObservers();
        MerkleTree merkleTree = ((EnterpriseCachePartitionSegment)this.cacheService.getSegment(this.partitionId)).getOrCreateMerkleTree(this.getName(), this.getConfig().getMerkleTreeConfig());
        if (merkleTree != null) {
            this.compositeCacheRSMutationObserver.add(new MerkleTreeRSMutationObserver(merkleTree, this.nodeEngine.getSerializationService()));
        }
    }

    @Override
    protected ValueComparator getValueComparatorOf(InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            return NativeValueComparator.INSTANCE;
        }
        return super.getValueComparatorOf(inMemoryFormat);
    }

    private static boolean isInvalidMaxSizePolicyExceptionDisabled() {
        return Boolean.getBoolean("disableInvalidMaxSizePolicyException");
    }

    @Override
    protected EvictionChecker createCacheEvictionChecker(int size, MaxSizePolicy maxSizePolicy) {
        if (maxSizePolicy == null) {
            if (HiDensityNativeMemoryCacheRecordStore.isInvalidMaxSizePolicyExceptionDisabled()) {
                return null;
            }
            throw new IllegalArgumentException("Max-size policy cannot be null");
        }
        MemoryStats memoryStats = ((EnterpriseSerializationService)this.nodeEngine.getSerializationService()).getMemoryManager().getMemoryStats();
        long maxNativeMemory = memoryStats instanceof PooledNativeMemoryStats ? ((PooledNativeMemoryStats)memoryStats).getMaxData() : memoryStats.getMaxNative();
        switch (maxSizePolicy) {
            case USED_NATIVE_MEMORY_SIZE: {
                return new HiDensityUsedNativeMemorySizeEvictionChecker(this.cacheInfo, size);
            }
            case USED_NATIVE_MEMORY_PERCENTAGE: {
                return new HiDensityUsedNativeMemoryPercentageEvictionChecker(this.cacheInfo, size, maxNativeMemory);
            }
            case FREE_NATIVE_MEMORY_SIZE: {
                return new HiDensityFreeNativeMemorySizeEvictionChecker(this.memoryManager, size);
            }
            case FREE_NATIVE_MEMORY_PERCENTAGE: {
                return new HiDensityFreeNativeMemoryPercentageEvictionChecker(this.memoryManager, size, maxNativeMemory);
            }
        }
        if (HiDensityNativeMemoryCacheRecordStore.isInvalidMaxSizePolicyExceptionDisabled()) {
            return null;
        }
        throw new IllegalArgumentException("Invalid max-size policy (" + String.valueOf((Object)maxSizePolicy) + ") for " + this.getClass().getName() + "! Only " + String.valueOf((Object)MaxSizePolicy.USED_NATIVE_MEMORY_SIZE) + ", " + String.valueOf((Object)MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE) + ", " + String.valueOf((Object)MaxSizePolicy.FREE_NATIVE_MEMORY_SIZE) + ", " + String.valueOf((Object)MaxSizePolicy.FREE_NATIVE_MEMORY_PERCENTAGE) + " are supported.");
    }

    @Override
    protected void forceRemoveRecord(Data key) {
        this.removeRecord(key);
        this.cacheRecordProcessor.disposeData(key);
    }

    private void ensureInitialized() {
        if (this.cacheInfo == null) {
            this.cacheInfo = ((EnterpriseCacheServiceExtension)((Object)this.cacheService)).getOrCreateHiDensityCacheInfo(this.cacheConfig.getNameWithPrefix());
        }
        if (this.serializationService == null) {
            this.serializationService = (EnterpriseSerializationService)this.nodeEngine.getSerializationService();
        }
        if (this.memoryManager == null) {
            this.memoryManager = this.serializationService.getMemoryManager();
            if (this.memoryManager instanceof PoolingMemoryManager) {
                this.memoryManager = ((PoolingMemoryManager)this.memoryManager).getMemoryManager();
            }
        }
        if (this.memoryManager == null) {
            throw new IllegalStateException("Native memory must be enabled to use Hi-Density storage!");
        }
        if (this.cacheRecordProcessor == null) {
            this.cacheRecordProcessor = new CacheHiDensityRecordProcessor<HiDensityNativeMemoryCacheRecord>(this.serializationService, new HiDensityNativeMemoryCacheRecordAccessor(this.serializationService, this.memoryManager), this.memoryManager, this.cacheInfo);
        }
    }

    @Override
    protected HiDensityNativeMemoryCacheRecordMap createRecordCacheMap() {
        if (this.records != null) {
            return (HiDensityNativeMemoryCacheRecordMap)this.records;
        }
        this.ensureInitialized();
        HiDensityNativeMemoryCacheRecordMap cacheRecordMap = null;
        int capacity = 128;
        NativeOutOfMemoryError oome = null;
        while (true) {
            try {
                cacheRecordMap = this.createMapInternal(capacity);
            }
            catch (NativeOutOfMemoryError e) {
                oome = e;
                if ((capacity >>= 1) > 0) continue;
            }
            break;
        }
        if (cacheRecordMap == null) {
            throw oome;
        }
        return cacheRecordMap;
    }

    protected HiDensityNativeMemoryCacheRecordMap createMapInternal(int capacity) {
        return new HiDensityNativeMemoryCacheRecordMap(capacity, (HiDensityRecordProcessor)this.cacheRecordProcessor, this.cacheInfo);
    }

    @Override
    protected CacheEntryProcessorEntry createCacheEntryProcessorEntry(Data key, HiDensityNativeMemoryCacheRecord record, long now, int completionId) {
        return new HiDensityNativeMemoryCacheEntryProcessorEntry(key, record, this, now, completionId);
    }

    boolean isMemoryBlockValid(MemoryBlock memoryBlock) {
        return memoryBlock != null && memoryBlock.address() != 0L;
    }

    @Override
    protected Data valueToData(Object value) {
        return this.cacheRecordProcessor.toData(value, DataType.NATIVE);
    }

    @Override
    protected Object dataToValue(Data data) {
        return this.cacheService.toObject(data);
    }

    @Override
    protected Object recordToValue(HiDensityNativeMemoryCacheRecord record) {
        if (!this.isMemoryBlockValid(record)) {
            return null;
        }
        NativeMemoryData valueData = record.getValue();
        return this.cacheRecordProcessor.convertData(valueData, DataType.HEAP);
    }

    @Override
    protected Data recordToData(HiDensityNativeMemoryCacheRecord record) {
        if (!this.isMemoryBlockValid(record)) {
            return null;
        }
        return record.getValue();
    }

    @Override
    protected Data toData(Object obj) {
        if (obj instanceof Data) {
            if (obj instanceof NativeMemoryData) {
                return (NativeMemoryData)obj;
            }
            return this.cacheRecordProcessor.convertData((Data)obj, DataType.NATIVE);
        }
        return super.toData(obj);
    }

    @Override
    protected Data toHeapData(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            Data data = (Data)obj;
            if (obj instanceof NativeMemoryData) {
                return this.cacheRecordProcessor.convertData(data, DataType.HEAP);
            }
            return data;
        }
        if (obj instanceof CacheRecord) {
            CacheRecord record = (CacheRecord)obj;
            Object value = record.getValue();
            return this.toHeapData(value);
        }
        return this.cacheRecordProcessor.toData(obj, DataType.HEAP);
    }

    @Override
    public CacheMergeResponse merge(SplitBrainMergeTypes.CacheMergeTypes<Object, Object> mergingEntry, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> mergePolicy, CallerProvenance callerProvenance) {
        CacheMergeResponse superResponse = super.merge(mergingEntry, mergePolicy, callerProvenance);
        CacheRecord heapCacheRecord = this.toHeapCacheRecord((HiDensityNativeMemoryCacheRecord)superResponse.getRecord());
        return new CacheMergeResponse(heapCacheRecord, superResponse.getResult());
    }

    @Override
    public final CacheRecord toHeapCacheRecord(HiDensityNativeMemoryCacheRecord record) {
        if (!this.isMemoryBlockValid(record)) {
            return null;
        }
        CacheDataRecord cacheRecord = new CacheDataRecord();
        cacheRecord.setCreationTime(record.getCreationTime());
        cacheRecord.setLastAccessTime(record.getLastAccessTime());
        cacheRecord.setHits(record.getHits());
        cacheRecord.setExpirationTime(record.getExpirationTime());
        cacheRecord.setValue(this.toHeapData(record.getValue()));
        cacheRecord.setExpiryPolicy(this.toHeapData(record.getExpiryPolicy()));
        return cacheRecord;
    }

    @Override
    public void disposeDeferredBlocks() {
        this.getRecordProcessor().disposeDeferredBlocks();
    }

    private HiDensityNativeMemoryCacheRecord toNativeMemoryCacheRecord(CacheRecord record) {
        if (record instanceof HiDensityNativeMemoryCacheRecord) {
            return (HiDensityNativeMemoryCacheRecord)record;
        }
        HiDensityNativeMemoryCacheRecord nativeMemoryRecord = this.createRecord(record.getValue(), record.getCreationTime(), record.getExpirationTime());
        nativeMemoryRecord.setLastAccessTime(record.getLastAccessTime());
        nativeMemoryRecord.setHits(record.getHits());
        return nativeMemoryRecord;
    }

    private NativeMemoryData toNativeMemoryData(Object data) {
        NativeMemoryData nativeMemoryData = !(data instanceof Data) ? (NativeMemoryData)this.cacheRecordProcessor.toData(data, DataType.NATIVE) : (!(data instanceof NativeMemoryData) ? (NativeMemoryData)this.cacheRecordProcessor.convertData((Data)data, DataType.NATIVE) : (NativeMemoryData)data);
        return nativeMemoryData;
    }

    @Override
    public Object getRecordValue(HiDensityNativeMemoryCacheRecord record) {
        return this.serializationService.toObject(record.getValue());
    }

    @Override
    public HiDensityRecordProcessor<HiDensityNativeMemoryCacheRecord> getRecordProcessor() {
        return this.cacheRecordProcessor;
    }

    @Override
    protected HiDensityNativeMemoryCacheRecord createRecord(Object value, long creationTime, long expiryTime) {
        this.evictIfRequired();
        this.markExpirable(expiryTime);
        return this.createRecordInternal(value, creationTime, expiryTime, this.newSequence());
    }

    @Override
    protected void initExpirationIterator() {
        if (this.expirationIterator == null || !this.expirationIterator.hasNext()) {
            this.expirationIterator = ((HiDensityNativeMemoryCacheRecordMap)this.records).entryIter(false);
        }
    }

    final HiDensityNativeMemoryCacheRecord createRecordInternal(Object value, long creationTime, long expiryTime, long sequence) {
        NativeMemoryData data = null;
        long recordAddress = 0L;
        try {
            recordAddress = this.cacheRecordProcessor.allocate(HiDensityNativeMemoryCacheRecord.SIZE);
            HiDensityNativeMemoryCacheRecord record = (HiDensityNativeMemoryCacheRecord)this.cacheRecordProcessor.newRecord();
            record.reset(recordAddress);
            record.setLastAccessTime(-1L);
            record.setSequence(sequence);
            if (creationTime >= 0L) {
                record.setCreationTime(creationTime);
            }
            if (expiryTime >= 0L) {
                record.setExpirationTime(expiryTime);
            }
            if (value != null) {
                data = this.toNativeMemoryData(value);
                record.setValueAddress(data.address());
            } else {
                record.setValueAddress(0L);
            }
            return record;
        }
        catch (NativeOutOfMemoryError e) {
            if (recordAddress != 0L) {
                this.cacheRecordProcessor.dispose(recordAddress);
            }
            if (this.isMemoryBlockValid(data)) {
                this.cacheRecordProcessor.disposeData(data);
            }
            throw e;
        }
    }

    long newSequence() {
        return 0L;
    }

    @Override
    protected void onCreateRecordError(Data key, Object value, long expiryTime, long now, boolean disableWriteThrough, int completionId, UUID origin, HiDensityNativeMemoryCacheRecord record, Throwable error) {
        if (this.isMemoryBlockValid(record)) {
            HiDensityNativeMemoryCacheRecord removed = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).remove(key);
            if (removed != null) {
                this.compositeCacheRSMutationObserver.onRemove(key, this.recordToValue(record));
            }
            if (value instanceof NativeMemoryData) {
                this.cacheRecordProcessor.free(record.address(), record.size());
                record.reset(0L);
            } else {
                this.cacheRecordProcessor.dispose(record);
            }
        }
    }

    @Override
    protected boolean evictIfExpired(Data key, HiDensityNativeMemoryCacheRecord record, long now) {
        if (super.evictIfExpired(key, record, now)) {
            this.getRecordProcessor().addDeferredDispose((NativeMemoryData)key);
            return true;
        }
        return false;
    }

    @Override
    public void evictExpiredEntries(int expirationPercentage) {
        super.evictExpiredEntries(expirationPercentage);
        this.getRecordProcessor().disposeDeferredBlocks();
    }

    @Override
    protected void onProcessExpiredEntry(Data key, HiDensityNativeMemoryCacheRecord record, long expiryTime, long now, UUID source, UUID origin) {
        super.onProcessExpiredEntry(key, record, expiryTime, now, source, origin);
        if (this.isMemoryBlockValid(record)) {
            this.cacheRecordProcessor.dispose(record);
        }
    }

    @Override
    protected void onUpdateRecord(Data key, HiDensityNativeMemoryCacheRecord record, Object value, Data oldDataValue) {
        NativeMemoryData nativeMemoryData;
        super.onUpdateRecord(key, record, value, oldDataValue);
        if (oldDataValue != null && oldDataValue instanceof NativeMemoryData && this.isMemoryBlockValid(nativeMemoryData = (NativeMemoryData)oldDataValue)) {
            this.cacheRecordProcessor.disposeData(nativeMemoryData);
        }
    }

    @Override
    protected void onUpdateRecordError(Data key, HiDensityNativeMemoryCacheRecord record, Object value, Data newDataValue, Data oldDataValue, Throwable error) {
        NativeMemoryData nativeMemoryData;
        if (newDataValue != null && newDataValue instanceof NativeMemoryData && newDataValue != value && this.isMemoryBlockValid(nativeMemoryData = (NativeMemoryData)newDataValue)) {
            this.cacheRecordProcessor.disposeData(nativeMemoryData);
        }
    }

    @Override
    protected void onDeleteRecord(Data key, HiDensityNativeMemoryCacheRecord record, boolean deleted) {
        if (deleted && this.isMemoryBlockValid(record)) {
            this.cacheRecordProcessor.dispose(record);
        }
    }

    @Override
    protected void onUpdateExpiryPolicy(Data key, HiDensityNativeMemoryCacheRecord record, Data oldDataExpiryPolicy) {
        super.onUpdateExpiryPolicy(key, record, oldDataExpiryPolicy);
        if (oldDataExpiryPolicy != null) {
            this.cacheRecordProcessor.disposeData(oldDataExpiryPolicy);
        }
    }

    @Override
    protected void onUpdateExpiryPolicyError(Data key, HiDensityNativeMemoryCacheRecord record, Data oldDataExpiryPolicy) {
        NativeMemoryData nativeMemoryData;
        super.onUpdateExpiryPolicyError(key, record, oldDataExpiryPolicy);
        if (oldDataExpiryPolicy instanceof NativeMemoryData && this.isMemoryBlockValid(nativeMemoryData = (NativeMemoryData)oldDataExpiryPolicy)) {
            record.setExpiryPolicy(nativeMemoryData);
        }
    }

    private HiDensityNativeMemoryCacheRecord putRecordInternal(Data key, CacheRecord record, boolean updateJournal) {
        NativeMemoryData nativeKey;
        HiDensityNativeMemoryCacheRecord oldRecord;
        if (!((HiDensityNativeMemoryCacheRecordMap)this.records).containsKey(key)) {
            this.evictIfRequired();
        }
        HiDensityNativeMemoryCacheRecord newRecord = this.toNativeMemoryCacheRecord(record);
        try {
            oldRecord = this.doPutRecord(key, newRecord, SOURCE_NOT_AVAILABLE, updateJournal);
        }
        catch (Throwable t) {
            if (newRecord != record) {
                this.cacheRecordProcessor.dispose(newRecord);
            }
            throw ExceptionUtil.rethrow(t);
        }
        if (oldRecord != null && key instanceof NativeMemoryData && this.isMemoryBlockValid(nativeKey = (NativeMemoryData)key)) {
            this.cacheRecordProcessor.addDeferredDispose(nativeKey);
        }
        if (oldRecord == null && key instanceof NativeMemoryData) {
            long size = this.cacheRecordProcessor.getSize((NativeMemoryData)key);
            this.cacheRecordProcessor.increaseUsedMemory(size);
        }
        if (record instanceof HiDensityNativeMemoryCacheRecord) {
            long size = this.cacheRecordProcessor.getSize(newRecord);
            this.cacheRecordProcessor.increaseUsedMemory(size += this.cacheRecordProcessor.getSize(newRecord.getValue()));
        }
        return oldRecord;
    }

    @Override
    public void putRecord(Data key, CacheRecord record, boolean updateJournal) {
        HiDensityNativeMemoryCacheRecord oldRecord = this.putRecordInternal(key, record, updateJournal);
        if (this.isMemoryBlockValid(oldRecord)) {
            this.cacheRecordProcessor.dispose(oldRecord);
        }
    }

    @Override
    public CacheRecord removeRecord(Data key) {
        HiDensityNativeMemoryCacheRecord removedRecord = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).remove(key);
        CacheRecord recordToReturn = null;
        if (this.isMemoryBlockValid(removedRecord)) {
            recordToReturn = this.toHeapCacheRecord(removedRecord);
            this.cacheRecordProcessor.dispose(removedRecord);
        }
        if (removedRecord != null) {
            this.compositeCacheRSMutationObserver.onRemove(key, recordToReturn != null ? recordToReturn.getValue() : null);
        }
        return recordToReturn;
    }

    private void onAccess(long now, HiDensityNativeMemoryCacheRecord record) {
        if (this.isEvictionEnabled()) {
            record.setLastAccessTime(now);
            record.incrementHits();
        }
    }

    @Override
    protected void onPut(Data key, Object value, ExpiryPolicy expiryPolicy, UUID caller, boolean getValue, boolean disableWriteThrough, HiDensityNativeMemoryCacheRecord record, Object oldValue, boolean isExpired, boolean isNewPut, boolean isSaveSucceed) {
        if (isSaveSucceed) {
            long size;
            if (isNewPut && key instanceof NativeMemoryData) {
                size = this.cacheRecordProcessor.getSize((NativeMemoryData)key);
                this.cacheRecordProcessor.increaseUsedMemory(size);
            }
            if (value instanceof NativeMemoryData) {
                size = this.cacheRecordProcessor.getSize((NativeMemoryData)value);
                this.cacheRecordProcessor.increaseUsedMemory(size);
            }
        }
        if (isSaveSucceed) {
            NativeMemoryData nativeKey;
            if (!isNewPut && key instanceof NativeMemoryData && this.isMemoryBlockValid(nativeKey = (NativeMemoryData)key)) {
                this.cacheRecordProcessor.addDeferredDispose(nativeKey);
            }
        } else {
            NativeMemoryData nativeValue;
            NativeMemoryData nativeKey;
            if (key instanceof NativeMemoryData && this.isMemoryBlockValid(nativeKey = (NativeMemoryData)key)) {
                this.cacheRecordProcessor.addDeferredDispose(nativeKey);
            }
            if (value instanceof NativeMemoryData && this.isMemoryBlockValid(nativeValue = (NativeMemoryData)value)) {
                this.cacheRecordProcessor.addDeferredDispose(nativeValue);
            }
        }
    }

    protected void onOwn(Data key, Object value, long ttlMillis, HiDensityNativeMemoryCacheRecord record, NativeMemoryData oldValueData, boolean isNewPut, boolean disableDeferredDispose) {
        long size;
        if (oldValueData != null) {
            this.cacheRecordProcessor.disposeData(oldValueData);
        }
        if (!isNewPut && key instanceof NativeMemoryData) {
            if (disableDeferredDispose) {
                this.serializationService.disposeData(key);
            } else {
                this.cacheRecordProcessor.addDeferredDispose((NativeMemoryData)key);
            }
        }
        if (isNewPut && key instanceof NativeMemoryData) {
            size = this.cacheRecordProcessor.getSize((NativeMemoryData)key);
            this.cacheRecordProcessor.increaseUsedMemory(size);
        }
        if (value instanceof NativeMemoryData) {
            size = this.cacheRecordProcessor.getSize((NativeMemoryData)value);
            this.cacheRecordProcessor.increaseUsedMemory(size);
        }
    }

    protected void onOwnError(Data key, Object value, long ttlMillis, HiDensityNativeMemoryCacheRecord record, NativeMemoryData oldValueData, boolean isNewPut, boolean disableDeferredDispose, Throwable error) {
        if (isNewPut && this.isMemoryBlockValid(record)) {
            HiDensityNativeMemoryCacheRecord removed = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).remove(key);
            if (removed != null) {
                this.compositeCacheRSMutationObserver.onRemove(key, this.recordToValue(removed));
            }
            if (value instanceof NativeMemoryData) {
                record.setValue(null);
                this.cacheRecordProcessor.free(record.address(), record.size());
                record.reset(0L);
            } else {
                this.cacheRecordProcessor.dispose(record);
            }
        }
    }

    @Override
    public CacheRecord putBackup(Data key, Object value, long creationTime, ExpiryPolicy expiryPolicy) {
        expiryPolicy = this.getExpiryPolicy(null, expiryPolicy);
        long ttl = this.expiryPolicyToTTL(expiryPolicy);
        this.evictIfRequired();
        return this.own(key, value, ttl, creationTime, false, true);
    }

    private long expiryPolicyToTTL(ExpiryPolicy expiryPolicy) {
        if (expiryPolicy == null) {
            return -1L;
        }
        try {
            Duration expiryDuration = expiryPolicy.getExpiryForCreation();
            if (expiryDuration == null || expiryDuration.isEternal()) {
                return -1L;
            }
            long durationAmount = expiryDuration.getDurationAmount();
            TimeUnit durationTimeUnit = expiryDuration.getTimeUnit();
            return TimeUnit.MILLISECONDS.convert(durationAmount, durationTimeUnit);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public CacheRecord putReplica(Data key, Object value, long creationTime, long ttlMillis) {
        return this.own(key, value, ttlMillis, creationTime, true, false);
    }

    private CacheRecord own(Data key, Object value, long ttlMillis, long creationTime, boolean disableDeferredDispose, boolean updateJournal) {
        long now = Clock.currentTimeMillis();
        HiDensityNativeMemoryCacheRecord record = null;
        NativeMemoryData oldValueData = null;
        boolean isNewPut = false;
        try {
            record = (HiDensityNativeMemoryCacheRecord)((HiDensityNativeMemoryCacheRecordMap)this.records).get(key);
            if (record == null) {
                isNewPut = true;
                record = this.createRecord(value, creationTime, Long.MAX_VALUE);
                ((HiDensityNativeMemoryCacheRecordMap)this.records).put(key, record);
                if (updateJournal) {
                    this.compositeCacheRSMutationObserver.onCreate(key, this.recordToValue(record));
                }
            } else {
                oldValueData = record.getValue();
                this.updateRecordValue(record, this.toNativeMemoryData(value));
                record.setCreationTime(creationTime);
                if (updateJournal) {
                    this.compositeCacheRSMutationObserver.onUpdate(key, this.toHeapData(oldValueData), this.recordToValue(record));
                }
            }
            this.onAccess(now, record);
            record.setTtlMillis(ttlMillis);
            this.onOwn(key, value, ttlMillis, record, oldValueData, isNewPut, disableDeferredDispose);
            return record;
        }
        catch (Throwable error) {
            this.onOwnError(key, value, ttlMillis, record, oldValueData, isNewPut, disableDeferredDispose, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    protected void onPutIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, UUID caller, boolean disableWriteThrough, HiDensityNativeMemoryCacheRecord record, boolean isExpired, boolean isSaveSucceed) {
        if (isSaveSucceed) {
            long size;
            if (key instanceof NativeMemoryData) {
                size = this.cacheRecordProcessor.getSize((NativeMemoryData)key);
                this.cacheRecordProcessor.increaseUsedMemory(size);
            }
            if (value instanceof NativeMemoryData) {
                size = this.cacheRecordProcessor.getSize((NativeMemoryData)value);
                this.cacheRecordProcessor.increaseUsedMemory(size);
            }
        }
    }

    @Override
    public boolean putIfAbsent(Data key, Object value, UUID caller, int completionId) {
        return this.putIfAbsent(key, value, (ExpiryPolicy)this.defaultExpiryPolicy.get(), caller, completionId);
    }

    @Override
    protected void onReplace(Data key, Object oldValue, Object newValue, ExpiryPolicy expiryPolicy, UUID caller, boolean getValue, HiDensityNativeMemoryCacheRecord record, boolean isExpired, boolean replaced) {
        if (replaced && newValue instanceof NativeMemoryData) {
            long size = this.cacheRecordProcessor.getSize((NativeMemoryData)newValue);
            this.cacheRecordProcessor.increaseUsedMemory(size);
        }
    }

    @Override
    public boolean replace(Data key, Object value, UUID caller, int completionId) {
        return this.replace(key, value, (ExpiryPolicy)this.defaultExpiryPolicy.get(), caller, completionId);
    }

    @Override
    public boolean replace(Data key, Object oldValue, Object newValue, UUID caller, int completionId) {
        return this.replace(key, oldValue, newValue, (ExpiryPolicy)this.defaultExpiryPolicy.get(), caller, completionId);
    }

    @Override
    protected void onRemoveError(Data key, Object value, UUID caller, boolean getValue, HiDensityNativeMemoryCacheRecord record, boolean removed, Throwable error) {
        if (removed && this.isMemoryBlockValid(record)) {
            this.cacheRecordProcessor.dispose(record);
            return;
        }
    }

    @Override
    public int forceEvict() {
        int evictedCount = ((HiDensityNativeMemoryCacheRecordMap)this.records).forceEvict(20, this);
        if (this.isStatisticsEnabled() && evictedCount > 0) {
            this.statistics.increaseCacheEvictions(evictedCount);
        }
        if (this.cacheInfo.increaseForceEvictionCount() == 1L) {
            this.logger.warning("Forced eviction invoked for the first time for Cache[name=" + this.getName() + "]");
        }
        this.cacheInfo.increaseForceEvictedEntryCount(evictedCount);
        return evictedCount;
    }

    @Override
    public void clear() {
        HazelcastMemoryManager memoryManager = this.serializationService.getMemoryManager();
        if (memoryManager == null || memoryManager.isDisposed()) {
            return;
        }
        super.clear();
    }

    @Override
    public void close(boolean onShutdown) {
        if (this.shouldExplicitlyClear(onShutdown)) {
            this.clear();
        } else {
            this.destroyEventJournal();
        }
        ((HiDensityNativeMemoryCacheRecordMap)this.records).dispose();
        this.closeListeners();
    }

    boolean shouldExplicitlyClear(boolean onShutdown) {
        NativeMemoryConfig nativeMemoryConfig = this.nodeEngine.getConfig().getNativeMemoryConfig();
        return !onShutdown || nativeMemoryConfig != null && nativeMemoryConfig.getAllocatorType() != NativeMemoryConfig.MemoryAllocatorType.POOLED;
    }

    @Override
    protected void onDestroy() {
        ((HiDensityNativeMemoryCacheRecordMap)this.records).dispose();
    }

    @Override
    public void destroy() {
        HazelcastMemoryManager memoryManager = this.serializationService.getMemoryManager();
        if (memoryManager == null || memoryManager.isDisposed()) {
            return;
        }
        super.destroy();
    }
}

