/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache;

import com.hazelcast.cache.HazelcastMemberCachingProvider;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.HazelcastClientCachingProvider;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.properties.ClusterProperty;
import java.net.URI;
import java.util.Properties;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;

public final class HazelcastCachingProvider
implements CachingProvider {
    public static final String HAZELCAST_CONFIG_LOCATION = "hazelcast.config.location";
    public static final String HAZELCAST_INSTANCE_NAME = "hazelcast.instance.name";
    public static final String HAZELCAST_INSTANCE_ITSELF = "hazelcast.instance.itself";
    public static final String MEMBER_CACHING_PROVIDER = HazelcastMemberCachingProvider.class.getName();
    @Deprecated
    public static final String SERVER_CACHING_PROVIDER = HazelcastMemberCachingProvider.class.getName();
    public static final String CLIENT_CACHING_PROVIDER = HazelcastClientCachingProvider.class.getName();
    public static final String SHARED_JCACHE_INSTANCE_NAME = "_hzinstance_jcache_shared";
    private static final String PROVIDER_TYPE_CLIENT = "client";
    private static final String PROVIDER_TYPE_MEMBER = "member";
    private static final String LEGACY_PROVIDER_TYPE_MEMBER = "server";
    private final CachingProvider delegate;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HazelcastCachingProvider() {
        void var1_5;
        Object var1_1 = null;
        String providerType = ClusterProperty.JCACHE_PROVIDER_TYPE.getSystemProperty();
        if (providerType != null) {
            if (PROVIDER_TYPE_CLIENT.equals(providerType)) {
                com.hazelcast.client.cache.impl.HazelcastClientCachingProvider hazelcastClientCachingProvider = new com.hazelcast.client.cache.impl.HazelcastClientCachingProvider();
            } else {
                if (!PROVIDER_TYPE_MEMBER.equals(providerType) && !LEGACY_PROVIDER_TYPE_MEMBER.equals(providerType)) throw new CacheException("Unknown CachingProvider type \"" + providerType + "\". Use \"client\" or \"member\" as provider type.");
                HazelcastServerCachingProvider hazelcastServerCachingProvider = new HazelcastServerCachingProvider();
            }
        } else {
            com.hazelcast.client.cache.impl.HazelcastClientCachingProvider hazelcastClientCachingProvider = new com.hazelcast.client.cache.impl.HazelcastClientCachingProvider();
        }
        this.delegate = var1_5;
    }

    public static Properties propertiesByLocation(String configFileLocation) {
        Properties properties = new Properties();
        properties.setProperty(HAZELCAST_CONFIG_LOCATION, configFileLocation);
        return properties;
    }

    public static Properties propertiesByInstanceName(String instanceName) {
        Properties properties = new Properties();
        properties.setProperty(HAZELCAST_INSTANCE_NAME, instanceName);
        return properties;
    }

    public static Properties propertiesByInstanceItself(HazelcastInstance instance) {
        Properties properties = new Properties();
        properties.put(HAZELCAST_INSTANCE_ITSELF, instance);
        return properties;
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        return this.delegate.getCacheManager(uri, classLoader, properties);
    }

    public ClassLoader getDefaultClassLoader() {
        return this.delegate.getDefaultClassLoader();
    }

    public URI getDefaultURI() {
        return this.delegate.getDefaultURI();
    }

    public Properties getDefaultProperties() {
        return this.delegate.getDefaultProperties();
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.delegate.getCacheManager(uri, classLoader);
    }

    public CacheManager getCacheManager() {
        return this.delegate.getCacheManager();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(ClassLoader classLoader) {
        this.delegate.close(classLoader);
    }

    public void close(URI uri, ClassLoader classLoader) {
        this.delegate.close(uri, classLoader);
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return this.delegate.isSupported(optionalFeature);
    }

    public String toString() {
        return "HazelcastCachingProvider{delegate=" + String.valueOf(this.delegate) + "}";
    }
}

