/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsClient;
import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsCredentials;
import com.hazelcast.aws.AwsCredentialsProvider;
import com.hazelcast.aws.AwsEc2Api;
import com.hazelcast.aws.AwsEcsApi;
import com.hazelcast.aws.AwsMetadataApi;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class AwsEcsClient
implements AwsClient {
    private static final ILogger LOGGER = Logger.getLogger(AwsClient.class);
    private final AwsEcsApi awsEcsApi;
    private final AwsEc2Api awsEc2Api;
    private final AwsMetadataApi awsMetadataApi;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final String cluster;
    private final AwsConfig awsConfig;

    AwsEcsClient(String cluster, AwsConfig awsConfig, AwsEcsApi awsEcsApi, AwsEc2Api awsEc2Api, AwsMetadataApi awsMetadataApi, AwsCredentialsProvider awsCredentialsProvider) {
        this.cluster = cluster;
        this.awsEcsApi = awsEcsApi;
        this.awsEc2Api = awsEc2Api;
        this.awsMetadataApi = awsMetadataApi;
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.awsConfig = awsConfig;
    }

    @Override
    public Map<String, String> getAddresses() {
        AwsCredentials credentials = this.awsCredentialsProvider.credentials();
        List<String> taskAddresses = Collections.emptyList();
        if (!this.awsConfig.anyOfEc2PropertiesConfigured()) {
            taskAddresses = this.awsEcsApi.listTaskPrivateAddresses(this.cluster, credentials);
            LOGGER.fine(String.format("AWS ECS DescribeTasks found the following addresses: %s", taskAddresses));
        }
        if (!taskAddresses.isEmpty()) {
            return this.awsEc2Api.describeNetworkInterfaces(taskAddresses, credentials);
        }
        if (DiscoveryMode.Client == this.awsConfig.getDiscoveryMode() && !this.awsConfig.anyOfEcsPropertiesConfigured()) {
            LOGGER.fine(String.format("No tasks found in ECS cluster: '%s'. Trying AWS EC2 Discovery.", this.cluster));
            return this.awsEc2Api.describeInstances(credentials);
        }
        return Collections.emptyMap();
    }

    @Override
    public String getAvailabilityZone() {
        return this.awsMetadataApi.availabilityZoneEcs();
    }
}

