/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsClient;
import com.hazelcast.aws.AwsClientConfigurator;
import com.hazelcast.aws.AwsConfig;
import com.hazelcast.aws.AwsProperties;
import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import com.hazelcast.spi.exception.NoCredentialsException;
import com.hazelcast.spi.exception.RestClientException;
import com.hazelcast.spi.utils.PortRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AwsDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final ILogger LOGGER = Logger.getLogger(AwsDiscoveryStrategy.class);
    private static final int HTTP_FORBIDDEN = 403;
    private static final String DEFAULT_PORT_RANGE = "5701-5708";
    private static final Integer DEFAULT_CONNECTION_RETRIES = 3;
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECONDS = 10;
    private static final int DEFAULT_READ_TIMEOUT_SECONDS = 10;
    private final AwsClient awsClient;
    private final PortRange portRange;
    private final Map<String, String> memberMetadata = new HashMap<String, String>();
    private boolean isKnownExceptionAlreadyLogged;
    private boolean isEmptyAddressListAlreadyLogged;

    AwsDiscoveryStrategy(Map<String, Comparable> properties) {
        this((DiscoveryNode)null, properties);
    }

    AwsDiscoveryStrategy(DiscoveryNode discoveryNode, Map<String, Comparable> properties) {
        super(LOGGER, properties);
        AwsConfig awsConfig = this.createAwsConfig().setDiscoveryMode(discoveryNode == null ? DiscoveryMode.Client : DiscoveryMode.Member).build();
        LOGGER.info("Using AWS discovery plugin with configuration: " + String.valueOf(awsConfig));
        this.awsClient = AwsClientConfigurator.createAwsClient(awsConfig);
        this.portRange = awsConfig.getHzPort();
    }

    AwsDiscoveryStrategy(Map<String, Comparable> properties, AwsClient client) {
        super(LOGGER, properties);
        this.awsClient = client;
        this.portRange = new PortRange(this.getPortRange());
    }

    private AwsConfig.Builder createAwsConfig() {
        try {
            return AwsConfig.builder().setAccessKey(this.getOrNull(AwsProperties.ACCESS_KEY)).setSecretKey(this.getOrNull(AwsProperties.SECRET_KEY)).setRegion(this.getOrDefault(AwsProperties.REGION.getDefinition(), null)).setIamRole(this.getOrNull(AwsProperties.IAM_ROLE)).setHostHeader((String)this.getOrNull(AwsProperties.HOST_HEADER.getDefinition())).setSecurityGroupName(this.getOrNull(AwsProperties.SECURITY_GROUP_NAME)).setTagKey(this.getOrNull(AwsProperties.TAG_KEY)).setTagValue(this.getOrNull(AwsProperties.TAG_VALUE)).setConnectionTimeoutSeconds(this.getOrDefault(AwsProperties.CONNECTION_TIMEOUT_SECONDS.getDefinition(), 10)).setConnectionRetries(this.getOrDefault(AwsProperties.CONNECTION_RETRIES.getDefinition(), DEFAULT_CONNECTION_RETRIES)).setReadTimeoutSeconds(this.getOrDefault(AwsProperties.READ_TIMEOUT_SECONDS.getDefinition(), 10)).setHzPort(new PortRange(this.getPortRange())).setCluster(this.getOrNull(AwsProperties.CLUSTER)).setFamily(this.getOrNull(AwsProperties.FAMILY)).setServiceName(this.getOrNull(AwsProperties.SERVICE_NAME));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("AWS configuration is not valid", e);
        }
    }

    private String getPortRange() {
        Object portRange = this.getOrNull(AwsProperties.PORT.getDefinition());
        if (portRange == null) {
            return DEFAULT_PORT_RANGE;
        }
        return portRange.toString();
    }

    @Override
    public Map<String, String> discoverLocalMetadata() {
        if (this.memberMetadata.isEmpty()) {
            String availabilityZone = this.awsClient.getAvailabilityZone();
            LOGGER.info(String.format("Availability zone found: '%s'", availabilityZone));
            this.memberMetadata.put("hazelcast.partition.group.zone", availabilityZone);
            this.getPlacementGroup().ifPresent(pg -> this.memberMetadata.put("hazelcast.partition.group.placement", availabilityZone + "-" + pg));
        }
        return this.memberMetadata;
    }

    private Optional<String> getPlacementGroup() {
        Optional<String> placementGroup = this.awsClient.getPlacementGroup();
        if (!placementGroup.isPresent()) {
            LOGGER.fine("No placement group is found.");
            return Optional.empty();
        }
        StringBuilder result = new StringBuilder(placementGroup.get());
        this.awsClient.getPlacementPartitionNumber().ifPresent(ppn -> result.append('-').append((String)ppn));
        LOGGER.info(String.format("Placement group found: '%s'", result));
        return Optional.of(result.toString());
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            Map<String, String> addresses = this.awsClient.getAddresses();
            this.logResult(addresses);
            ArrayList<DiscoveryNode> result = new ArrayList<DiscoveryNode>();
            for (Map.Entry<String, String> entry : addresses.entrySet()) {
                for (int port = this.portRange.getFromPort(); port <= this.portRange.getToPort(); ++port) {
                    Address privateAddress = new Address(entry.getKey(), port);
                    Address publicAddress = new Address(entry.getValue(), port);
                    result.add(new SimpleDiscoveryNode(privateAddress, publicAddress));
                }
            }
            return result;
        }
        catch (NoCredentialsException e) {
            if (!this.isKnownExceptionAlreadyLogged) {
                LOGGER.warning("No AWS credentials found! Starting standalone. To use Hazelcast AWS discovery, configure properties (access-key, secret-key) or assign the required IAM Role to your EC2 instance");
                LOGGER.finest(e);
                this.isKnownExceptionAlreadyLogged = true;
            }
        }
        catch (RestClientException e) {
            if (e.getHttpErrorCode() == 403) {
                if (!this.isKnownExceptionAlreadyLogged) {
                    LOGGER.warning("AWS IAM Role Policy missing 'ec2:DescribeInstances' Action! Starting standalone.");
                    this.isKnownExceptionAlreadyLogged = true;
                }
                LOGGER.finest(e);
            } else {
                LOGGER.warning("Cannot discover nodes. Starting standalone.", e);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Cannot discover nodes. Starting standalone.", e);
        }
        return Collections.emptyList();
    }

    private void logResult(Map<String, String> addresses) {
        if (addresses.isEmpty() && !this.isEmptyAddressListAlreadyLogged) {
            LOGGER.warning("No IP addresses found! Starting standalone.");
            this.isEmptyAddressListAlreadyLogged = true;
        }
        LOGGER.fine(String.format("Found the following (private => public) addresses: %s", addresses));
    }

    private String getOrNull(AwsProperties awsProperties) {
        return (String)this.getOrNull(awsProperties.getDefinition());
    }
}

