/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

class GenericMapStoreProperties {
    final String dataConnectionRef;
    final String tableName;
    final String idColumn;
    final List<String> columns;
    final Set<String> allColumns = new HashSet<String>();
    final boolean idColumnInColumns;
    final String compactTypeName;
    final boolean loadAllKeys;
    final boolean singleColumnAsValue;

    GenericMapStoreProperties(Properties properties, String mapName) {
        this.dataConnectionRef = properties.getProperty("data-connection-ref");
        this.tableName = properties.getProperty("external-name", mapName);
        this.idColumn = properties.getProperty("id-column", "id");
        String columnsProperty = properties.getProperty("columns");
        if (columnsProperty != null) {
            List<String> columnsList = Arrays.asList(columnsProperty.split(","));
            this.columns = Collections.unmodifiableList(columnsList);
        } else {
            this.columns = Collections.emptyList();
        }
        this.allColumns.add(this.idColumn);
        this.allColumns.addAll(this.columns);
        this.idColumnInColumns = this.columns.isEmpty() || this.columns.contains(this.idColumn);
        this.compactTypeName = properties.getProperty("type-name", mapName);
        String value = properties.getProperty("load-all-keys", "true");
        this.loadAllKeys = Boolean.parseBoolean(value);
        String singleColumnAsValueString = properties.getProperty("single-column-as-value", "false");
        this.singleColumnAsValue = Boolean.parseBoolean(singleColumnAsValueString);
    }

    boolean hasColumns() {
        return !this.columns.isEmpty();
    }

    public Set<String> getAllColumns() {
        return this.allColumns;
    }
}

