/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import com.hazelcast.map.MapLoaderLifecycleSupport;
import com.hazelcast.map.MapStore;
import com.hazelcast.mapstore.GenericMapLoader;
import com.hazelcast.mapstore.JdbcParameters;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

public class GenericMapStore<K, V>
extends GenericMapLoader<K, V>
implements MapStore<K, V>,
MapLoaderLifecycleSupport {
    public void store(K key, V value) {
        this.awaitSuccessfulInit();
        JdbcParameters jdbcParameters = JdbcParameters.convert(key, value, this.columnMetadataList, this.genericMapStoreProperties.idColumn, this.genericMapStoreProperties.singleColumnAsValue);
        try {
            this.sqlService.execute(this.queries.storeSink(), jdbcParameters.getParams()).close();
        }
        catch (Exception e) {
            if (GenericMapStore.isIntegrityConstraintViolation(e)) {
                jdbcParameters.shiftIdParameterToEnd();
                String updateSQL = this.queries.storeUpdate();
                this.sqlService.execute(updateSQL, jdbcParameters.getParams()).close();
            }
            throw e;
        }
    }

    public void storeAll(Map<K, V> map) {
        this.awaitSuccessfulInit();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.store(entry.getKey(), entry.getValue());
        }
    }

    public void delete(K key) {
        this.awaitSuccessfulInit();
        this.sqlService.execute(this.queries.delete(), new Object[]{key}).close();
    }

    public void deleteAll(Collection<K> keys) {
        this.awaitSuccessfulInit();
        if (keys.isEmpty()) {
            return;
        }
        this.sqlService.execute(this.queries.deleteAll(keys.size()), keys.toArray()).close();
    }

    static boolean isIntegrityConstraintViolation(Exception exception) {
        String sqlState;
        boolean result = false;
        SQLException sqlException = GenericMapStore.findSQLException(exception);
        if (sqlException != null && (sqlState = sqlException.getSQLState()) != null) {
            result = sqlState.startsWith("23");
        }
        return result;
    }

    static SQLException findSQLException(Throwable throwable) {
        Throwable rootCause = throwable;
        while (rootCause.getCause() != null && rootCause.getCause() != rootCause) {
            if (!((rootCause = rootCause.getCause()) instanceof SQLException)) continue;
            return (SQLException)rootCause;
        }
        return null;
    }
}

