/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.impl;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.processor.TransactionPoolSnapshotUtility;
import com.hazelcast.jet.impl.processor.TwoPhaseSnapshotCommitUtility;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.kafka.KafkaDataConnection;
import com.hazelcast.jet.kafka.impl.ResumeTransactionUtil;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.logging.ILogger;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;

public final class WriteKafkaP<T, K, V>
implements Processor {
    public static final int TXN_POOL_SIZE = 2;
    private final FunctionEx<String, KafkaProducer<K, V>> getProducerFn;
    private final Function<? super T, ? extends ProducerRecord<K, V>> toRecordFn;
    private final boolean exactlyOnce;
    private Processor.Context context;
    private TransactionPoolSnapshotUtility<KafkaTransactionId, KafkaTransaction<K, V>> snapshotUtility;
    private final AtomicReference<Throwable> lastError = new AtomicReference();
    private final Callback callback = (metadata, exception) -> {
        if (exception != null) {
            this.lastError.compareAndSet(null, exception);
        }
    };

    private WriteKafkaP(@Nonnull FunctionEx<String, KafkaProducer<K, V>> getProducerFn, @Nonnull Function<? super T, ? extends ProducerRecord<K, V>> toRecordFn, boolean exactlyOnce) {
        this.getProducerFn = getProducerFn;
        this.toRecordFn = toRecordFn;
        this.exactlyOnce = exactlyOnce;
    }

    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.context = context;
        ProcessingGuarantee guarantee = context.processingGuarantee() == ProcessingGuarantee.EXACTLY_ONCE && !this.exactlyOnce ? ProcessingGuarantee.AT_LEAST_ONCE : context.processingGuarantee();
        this.snapshotUtility = new TransactionPoolSnapshotUtility(outbox, context, false, guarantee, 2, (BiFunctionEx & Serializable)(processorIndex, txnIndex) -> new KafkaTransactionId(context.jobId(), context.jobConfig().getName(), context.vertexName(), (int)processorIndex, (int)txnIndex), (FunctionEx & Serializable)txnId -> {
            KafkaProducer producer = (KafkaProducer)this.getProducerFn.apply((Object)(txnId == null ? null : txnId.getKafkaId()));
            return new KafkaTransaction((KafkaTransactionId)txnId, producer, context.logger());
        }, (ConsumerEx & Serializable)txnId -> {
            try {
                this.recoverTransaction((KafkaTransactionId)txnId, true);
            }
            catch (ProducerFencedException e) {
                context.logger().warning("Failed to finish the commit of a transaction ID saved in the snapshot, data loss can occur. Transaction id: " + txnId.getKafkaId(), (Throwable)e);
            }
        }, (ConsumerEx & Serializable)txnId -> this.recoverTransaction((KafkaTransactionId)txnId, false));
    }

    public boolean tryProcess() {
        this.checkError();
        return this.snapshotUtility.tryProcess();
    }

    public void process(int ordinal, @Nonnull Inbox inbox) {
        Object item;
        KafkaTransaction txn = (KafkaTransaction)this.snapshotUtility.activeTransaction();
        if (txn == null) {
            return;
        }
        this.checkError();
        while ((item = inbox.peek()) != null) {
            try {
                txn.producer.send(this.toRecordFn.apply(item), this.callback);
            }
            catch (TimeoutException ignored) {
                return;
            }
            inbox.remove();
        }
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    public boolean complete() {
        KafkaTransaction transaction = (KafkaTransaction)this.snapshotUtility.activeTransaction();
        if (transaction == null) {
            return false;
        }
        transaction.flush();
        LoggingUtil.logFinest((ILogger)this.context.logger(), (String)"flush in complete() done, %s", (Object)transaction.transactionId);
        this.checkError();
        this.snapshotUtility.afterCompleted();
        return true;
    }

    public boolean snapshotCommitPrepare() {
        if (!this.snapshotUtility.snapshotCommitPrepare()) {
            return false;
        }
        this.checkError();
        return true;
    }

    public boolean snapshotCommitFinish(boolean commitTransactions) {
        return this.snapshotUtility.snapshotCommitFinish(commitTransactions);
    }

    public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        this.snapshotUtility.restoreFromSnapshot(inbox);
    }

    public boolean isCooperative() {
        return false;
    }

    private void recoverTransaction(KafkaTransactionId txnId, boolean commit) {
        try (KafkaProducer p = (KafkaProducer)this.getProducerFn.apply((Object)txnId.getKafkaId());){
            if (commit) {
                ResumeTransactionUtil.resumeTransaction(p, txnId.producerId(), txnId.epoch());
                try {
                    p.commitTransaction();
                }
                catch (InvalidTxnStateException e) {
                    this.context.logger().fine("Failed to commit transaction with ID restored from the snapshot. This happens normally when the transaction was committed in phase 2 of the snapshot and can be ignored, but can happen also if the transaction wasn't committed in phase 2 and the broker lost it (in this case data written in it is lost). Transaction ID: " + String.valueOf(txnId), (Throwable)e);
                }
            } else {
                p.initTransactions();
            }
        }
    }

    public void close() {
        if (this.snapshotUtility != null) {
            this.snapshotUtility.close();
        }
    }

    private void checkError() {
        Throwable t = this.lastError.get();
        if (t != null) {
            throw ExceptionUtil.sneakyThrow((Throwable)t);
        }
    }

    public static <T, K, V> SupplierEx<Processor> supplier(@Nonnull Properties properties, @Nonnull Function<? super T, ? extends ProducerRecord<K, V>> toRecordFn, boolean exactlyOnce) {
        if (properties.containsKey("transactional.id")) {
            throw new IllegalArgumentException("Property `transactional.id` must not be set, Jet sets it as needed");
        }
        return (SupplierEx & Serializable)() -> new WriteKafkaP((FunctionEx & Serializable)s -> {
            Properties castProperties = properties;
            HashMap<Object, Object> copy = new HashMap<Object, Object>(castProperties);
            if (s != null) {
                copy.put("transactional.id", s);
            }
            return new KafkaProducer(copy);
        }, toRecordFn, exactlyOnce);
    }

    public static <T, K, V> ProcessorSupplier supplier(final @Nonnull DataConnectionRef dataConnectionRef, final @Nonnull Function<? super T, ? extends ProducerRecord<K, V>> toRecordFn, final boolean exactlyOnce) {
        return new ProcessorSupplier(){
            private static final long serialVersionUID = 1L;
            private transient KafkaDataConnection kafkaDataConnection;

            public void init(@Nonnull ProcessorSupplier.Context context) {
                this.kafkaDataConnection = (KafkaDataConnection)context.dataConnectionService().getAndRetainDataConnection(dataConnectionRef.getName(), KafkaDataConnection.class);
            }

            @Nonnull
            public Collection<? extends Processor> get(int count) {
                return IntStream.range(0, count).mapToObj(i -> new WriteKafkaP((FunctionEx & Serializable)txnId -> this.kafkaDataConnection.getProducer((String)txnId), toRecordFn, exactlyOnce)).collect(Collectors.toList());
            }

            public void close(@Nullable Throwable error) {
                if (this.kafkaDataConnection != null) {
                    this.kafkaDataConnection.release();
                }
            }
        };
    }

    public static <T, K, V> ProcessorSupplier supplier(final @Nonnull DataConnectionRef dataConnectionRef, final @Nonnull Properties properties, final @Nonnull Function<? super T, ? extends ProducerRecord<K, V>> toRecordFn, final boolean exactlyOnce) {
        return new ProcessorSupplier(){
            private static final long serialVersionUID = 1L;
            private transient KafkaDataConnection kafkaDataConnection;

            public void init(@Nonnull ProcessorSupplier.Context context) {
                this.kafkaDataConnection = (KafkaDataConnection)context.dataConnectionService().getAndRetainDataConnection(dataConnectionRef.getName(), KafkaDataConnection.class);
            }

            @Nonnull
            public Collection<? extends Processor> get(int count) {
                return IntStream.range(0, count).mapToObj(i -> new WriteKafkaP((FunctionEx & Serializable)txnId -> this.kafkaDataConnection.getProducer((String)txnId, properties), toRecordFn, exactlyOnce)).collect(Collectors.toList());
            }

            public void close(@Nullable Throwable error) {
                if (this.kafkaDataConnection != null) {
                    this.kafkaDataConnection.release();
                }
            }
        };
    }

    private static final class KafkaTransaction<K, V>
    implements TwoPhaseSnapshotCommitUtility.TransactionalResource<KafkaTransactionId> {
        private final KafkaProducer<K, V> producer;
        private final ILogger logger;
        private final KafkaTransactionId transactionId;
        private boolean txnInitialized;

        private KafkaTransaction(KafkaTransactionId transactionId, KafkaProducer<K, V> producer, ILogger logger) {
            this.transactionId = transactionId;
            this.producer = producer;
            this.logger = logger;
        }

        public KafkaTransactionId id() {
            return this.transactionId;
        }

        public void begin() {
            if (!this.txnInitialized) {
                this.logger.fine("initTransactions in begin %s", (Object)this.transactionId);
                this.txnInitialized = true;
                this.producer.initTransactions();
                this.transactionId.updateProducerAndEpoch(this.producer);
            }
            this.producer.beginTransaction();
        }

        public boolean flush() {
            this.producer.flush();
            return true;
        }

        public void commit() {
            if (this.transactionId != null) {
                this.producer.commitTransaction();
            }
        }

        public void rollback() {
            if (this.transactionId != null) {
                this.producer.abortTransaction();
            }
        }

        public void release() {
            this.producer.close(Duration.ZERO);
        }
    }

    public static class KafkaTransactionId
    implements TwoPhaseSnapshotCommitUtility.TransactionId,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int processorIndex;
        private long producerId = -1L;
        private short epoch = (short)-1;
        private final String kafkaId;
        private final int hashCode;

        KafkaTransactionId(long jobId, String jobName, @Nonnull String vertexId, int processorIndex, int transactionIndex) {
            this.processorIndex = processorIndex;
            this.kafkaId = "jet.job-" + Util.idToString((long)jobId) + "." + KafkaTransactionId.sanitize(jobName) + "." + KafkaTransactionId.sanitize(vertexId) + "." + processorIndex + "-" + transactionIndex;
            this.hashCode = Objects.hash(jobId, vertexId, processorIndex);
        }

        public int index() {
            return this.processorIndex;
        }

        long producerId() {
            return this.producerId;
        }

        short epoch() {
            return this.epoch;
        }

        void updateProducerAndEpoch(KafkaProducer<?, ?> producer) {
            this.producerId = ResumeTransactionUtil.getProducerId(producer);
            this.epoch = ResumeTransactionUtil.getEpoch(producer);
        }

        public String toString() {
            return this.getKafkaId() + ",producerId=" + this.producerId + ",epoch=" + this.epoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KafkaTransactionId that = (KafkaTransactionId)o;
            return this.getKafkaId().equals(that.getKafkaId());
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Nonnull
        String getKafkaId() {
            return this.kafkaId;
        }

        private static String sanitize(String s) {
            if (s == null) {
                return "";
            }
            return s.replaceAll("[^\\p{Alnum}.\\-_$#/{}\\[\\]]", "_");
        }
    }
}

