/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.impl;

import java.util.Map;
import org.apache.avro.Schema;

public abstract class AbstractHazelcastAvroSerde {
    public static final String OPTION_KEY_AVRO_SCHEMA = "keyAvroSchema";
    public static final String OPTION_VALUE_AVRO_SCHEMA = "valueAvroSchema";

    protected Schema getSchema(Map<String, ?> configs, boolean isKey) {
        Object schema = configs.get(isKey ? OPTION_KEY_AVRO_SCHEMA : OPTION_VALUE_AVRO_SCHEMA);
        if (schema == null) {
            throw new IllegalArgumentException("Schema must be provided for " + (isKey ? "key" : "value"));
        }
        if (schema instanceof Schema) {
            return (Schema)schema;
        }
        if (schema instanceof String) {
            return new Schema.Parser().parse((String)schema);
        }
        throw new IllegalArgumentException("Provided schema cannot be recognized");
    }
}

