/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.python;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.python.InvalidPythonServiceConfigException;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PythonServiceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String HANDLER_FUNCTION_DEFAULT = "transform_list";
    private File baseDir;
    private File handlerFile;
    private String handlerModule;
    private String handlerFunction = "transform_list";
    private BiFunctionEx<String, Integer, ? extends ManagedChannelBuilder<?>> channelFn = NettyChannelBuilder::forAddress;

    public void validate() {
        StringJoiner missingMandatoryFields = new StringJoiner(", ");
        if (this.baseDir == null) {
            if (this.handlerFile == null) {
                missingMandatoryFields.add("(baseDir or handlerFile)");
            }
        } else if (this.handlerModule == null) {
            missingMandatoryFields.add("handlerModule");
        }
        if (this.handlerFunction == null) {
            missingMandatoryFields.add("handlerFunction");
        }
        if (this.channelFn == null) {
            missingMandatoryFields.add("channelFn");
        }
        if (missingMandatoryFields.length() > 0) {
            throw new InvalidPythonServiceConfigException("The supplied Python Service configuration is missing these mandatory fields: " + String.valueOf(missingMandatoryFields));
        }
    }

    @Nullable
    public File baseDir() {
        return this.baseDir;
    }

    @Nonnull
    public PythonServiceConfig setBaseDir(@Nonnull String baseDir) {
        if (this.handlerFile != null) {
            throw new IllegalArgumentException("You already set handlerFile so you can't set baseDir. When using baseDir, set handlerModule instead.");
        }
        String baseDirStr = PythonServiceConfig.requireNonBlank(baseDir, "baseDir");
        try {
            File dir = new File(baseDirStr).getCanonicalFile();
            if (!dir.isDirectory()) {
                throw new IOException("Not a directory: " + String.valueOf(dir));
            }
            this.baseDir = dir;
        }
        catch (IOException e) {
            throw new InvalidPythonServiceConfigException("Invalid baseDir argument", e);
        }
        return this;
    }

    @Nullable
    public File handlerFile() {
        return this.handlerFile;
    }

    @Nonnull
    public PythonServiceConfig setHandlerFile(@Nonnull String handlerFile) {
        if (this.baseDir != null) {
            throw new IllegalStateException("You already set baseDir so you can't set handlerFile. If you want to set the handler module, call setHandlerModule().");
        }
        if (this.handlerModule != null) {
            throw new IllegalStateException("You already set handlerModule, it would be overwritten by setting handlerFile");
        }
        String handlerFileStr = PythonServiceConfig.requireNonBlank(handlerFile, "handlerFile");
        if (!handlerFileStr.toLowerCase(Locale.ROOT).endsWith(".py")) {
            throw new IllegalArgumentException("The handler file must be a .py file");
        }
        try {
            File file = new File(handlerFileStr).getCanonicalFile();
            if (!file.isFile() || !file.canRead()) {
                throw new IOException("Not a regular, readable file: " + String.valueOf(file));
            }
            this.handlerFile = file;
            this.handlerModule = file.getName().replaceFirst("\\.py$", "");
        }
        catch (IOException e) {
            throw new InvalidPythonServiceConfigException("Invalid handlerFile argument", e);
        }
        return this;
    }

    @Nullable
    public String handlerModule() {
        return this.handlerModule;
    }

    @Nonnull
    public PythonServiceConfig setHandlerModule(@Nonnull String handlerModule) {
        if (this.handlerFile != null) {
            throw new IllegalStateException("You already set handlerFile, it would be overwritten by setting handlerModule");
        }
        this.handlerModule = PythonServiceConfig.requireNonBlank(handlerModule, "handlerModule");
        return this;
    }

    @Nonnull
    public String handlerFunction() {
        return this.handlerFunction;
    }

    @Nonnull
    public PythonServiceConfig setHandlerFunction(@Nonnull String handlerFunction) {
        this.handlerFunction = PythonServiceConfig.requireNonBlank(handlerFunction, "handlerFunction");
        return this;
    }

    private static String requireNonBlank(@Nonnull String in, @Nonnull String name) {
        if ((in = in.trim()).isEmpty()) {
            throw new IllegalArgumentException("Parameter must not be blank: " + name);
        }
        return in;
    }

    @Nonnull
    public BiFunctionEx<String, Integer, ? extends ManagedChannelBuilder<?>> channelFn() {
        return this.channelFn;
    }

    @Nonnull
    public PythonServiceConfig setChannelFn(@Nonnull BiFunctionEx<String, Integer, ? extends ManagedChannelBuilder<?>> channelFn) {
        this.channelFn = (BiFunctionEx)Preconditions.isNotNull(channelFn, (String)"channelFn");
        return this;
    }
}

