/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;

public final class WriteHadoopOldApiP<T, K, V>
extends AbstractProcessor {
    private final RecordWriter<K, V> recordWriter;
    private final TaskAttemptContextImpl taskAttemptContext;
    private final OutputCommitter outputCommitter;
    private final FunctionEx<? super T, K> extractKeyFn;
    private final FunctionEx<? super T, V> extractValueFn;

    private WriteHadoopOldApiP(RecordWriter<K, V> recordWriter, TaskAttemptContextImpl taskAttemptContext, OutputCommitter outputCommitter, FunctionEx<? super T, K> extractKeyFn, FunctionEx<? super T, V> extractValueFn) {
        this.recordWriter = recordWriter;
        this.taskAttemptContext = taskAttemptContext;
        this.outputCommitter = outputCommitter;
        this.extractKeyFn = extractKeyFn;
        this.extractValueFn = extractValueFn;
    }

    public boolean isCooperative() {
        return false;
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        Object t2 = item;
        this.recordWriter.write(this.extractKeyFn.apply(t2), this.extractValueFn.apply(t2));
        return true;
    }

    public void close() throws Exception {
        this.recordWriter.close(Reporter.NULL);
        if (this.outputCommitter.needsTaskCommit(this.taskAttemptContext)) {
            this.outputCommitter.commitTask(this.taskAttemptContext);
        }
    }

    private static class Supplier<T, K, V>
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final JobConf jobConf;
        private final FunctionEx<? super T, K> extractKeyFn;
        private final FunctionEx<? super T, V> extractValueFn;
        private transient ProcessorSupplier.Context context;
        private transient OutputCommitter outputCommitter;
        private transient JobContextImpl jobContext;

        Supplier(JobConf jobConf, FunctionEx<? super T, K> extractKeyFn, FunctionEx<? super T, V> extractValueFn) {
            this.jobConf = jobConf;
            this.extractKeyFn = extractKeyFn;
            this.extractValueFn = extractValueFn;
        }

        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.context = context;
            this.outputCommitter = this.jobConf.getOutputCommitter();
            this.jobContext = new JobContextImpl(this.jobConf, (org.apache.hadoop.mapreduce.JobID)new JobID());
        }

        @Nonnull
        public List<Processor> get(int count) {
            return IntStream.range(0, count).mapToObj(i -> {
                try {
                    String uuid = this.context.hazelcastInstance().getCluster().getLocalMember().getUuid().toString();
                    TaskAttemptID taskAttemptID = new TaskAttemptID("jet-node-" + uuid, this.jobContext.getJobID().getId(), TaskType.JOB_SETUP, i, 0);
                    JobConf copiedConfig = new JobConf(this.jobConf);
                    copiedConfig.set("mapred.task.id", taskAttemptID.toString());
                    copiedConfig.setInt("mapred.task.partition", i);
                    TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(copiedConfig, taskAttemptID);
                    OutputFormat outFormat = copiedConfig.getOutputFormat();
                    RecordWriter recordWriter = outFormat.getRecordWriter(null, copiedConfig, uuid + "-" + i, Reporter.NULL);
                    return new WriteHadoopOldApiP(recordWriter, taskAttemptContext, this.outputCommitter, this.extractKeyFn, this.extractValueFn);
                }
                catch (IOException e) {
                    throw new JetException((Throwable)e);
                }
            }).collect(Collectors.toList());
        }
    }

    public static class MetaSupplier<T, K, V>
    implements ProcessorMetaSupplier {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final JobConf jobConf;
        private final FunctionEx<? super T, K> extractKeyFn;
        private final FunctionEx<? super T, V> extractValueFn;
        private transient OutputCommitter outputCommitter;
        private transient JobContextImpl jobContext;

        public MetaSupplier(JobConf jobConf, FunctionEx<? super T, K> extractKeyFn, FunctionEx<? super T, V> extractValueFn) {
            this.jobConf = jobConf;
            this.extractKeyFn = extractKeyFn;
            this.extractValueFn = extractValueFn;
        }

        public int preferredLocalParallelism() {
            return 2;
        }

        public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
            this.outputCommitter = this.jobConf.getOutputCommitter();
            this.jobContext = new JobContextImpl(this.jobConf, (org.apache.hadoop.mapreduce.JobID)new JobID());
            this.outputCommitter.setupJob(this.jobContext);
        }

        public void close(Throwable error) throws Exception {
            if (this.outputCommitter != null && this.jobContext != null) {
                this.outputCommitter.commitJob(this.jobContext);
            }
        }

        @Nonnull
        public FunctionEx<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return (FunctionEx & Serializable)address -> new Supplier(this.jobConf, this.extractKeyFn, this.extractValueFn);
        }
    }
}

