/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.dynamic;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.dynamic.DynMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"testing"})
@InterfaceStability.Unstable
public final class BindingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BindingUtils.class);

    private BindingUtils() {
    }

    public static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No class {}", (Object)className, (Object)e);
            return null;
        }
    }

    public static Class<?> loadClassSafely(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> loadClass(ClassLoader cl, String className) {
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No class {}", (Object)className, (Object)e);
            return null;
        }
    }

    public static <T> DynMethods.UnboundMethod loadInvocation(Class<?> source, Class<? extends T> returnType, String name, Class<?> ... parameterTypes) {
        if (source != null) {
            DynMethods.UnboundMethod m4 = new DynMethods.Builder(name).impl(source, name, parameterTypes).orNoop().build();
            if (m4.isNoop()) {
                LOG.debug("Failed to load method {} from {}", (Object)name, (Object)source);
            } else {
                LOG.debug("Found method {} from {}", (Object)name, (Object)source);
            }
            return m4;
        }
        return BindingUtils.noop(name);
    }

    public static <T> DynMethods.UnboundMethod loadStaticMethod(Class<?> source, Class<? extends T> returnType, String name, Class<?> ... parameterTypes) {
        DynMethods.UnboundMethod method = BindingUtils.loadInvocation(source, returnType, name, parameterTypes);
        if (!BindingUtils.available(method)) {
            LOG.debug("Method not found: {}", (Object)name);
        }
        Preconditions.checkState(method.isStatic(), "Method is not static %s", method);
        return method;
    }

    public static DynMethods.UnboundMethod noop(String name) {
        return new DynMethods.Builder(name).orNoop().build();
    }

    public static boolean implemented(DynMethods.UnboundMethod ... methods) {
        for (DynMethods.UnboundMethod method : methods) {
            if (!method.isNoop()) continue;
            return false;
        }
        return true;
    }

    public static void checkAvailable(DynMethods.UnboundMethod method) throws UnsupportedOperationException {
        if (!BindingUtils.available(method)) {
            throw new UnsupportedOperationException("Unbound " + method);
        }
    }

    public static boolean available(DynMethods.UnboundMethod method) {
        return !method.isNoop();
    }

    public static <T> T extractIOEs(Supplier<T> call) throws IOException {
        try {
            return call.get();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

