/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class PathOutputCommitter
extends OutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(PathOutputCommitter.class);
    private final JobContext context;

    protected PathOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        this.context = Preconditions.checkNotNull(context, "Null context");
        LOG.debug("Instantiating committer {} with output path {} and task context {}", this, outputPath, context);
    }

    protected PathOutputCommitter(Path outputPath, JobContext context) throws IOException {
        this.context = Preconditions.checkNotNull(context, "Null context");
        LOG.debug("Instantiating committer {} with output path {} and job context {}", this, outputPath, context);
    }

    public abstract Path getOutputPath();

    public boolean hasOutputPath() {
        return this.getOutputPath() != null;
    }

    public abstract Path getWorkPath() throws IOException;

    public String toString() {
        return "PathOutputCommitter{context=" + this.context + "; " + super.toString() + '}';
    }
}

